/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.inmemory;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Stream;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStorageEngineTest;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InMemoryEventStorageEngineTest
extends EventStorageEngineTest {
    private static final EventMessage<Object> TEST_EVENT = GenericEventMessage.asEventMessage((Object)"test");
    private InMemoryEventStorageEngine testSubject;

    InMemoryEventStorageEngineTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new InMemoryEventStorageEngine();
        this.setTestSubject((EventStorageEngine)this.testSubject);
    }

    @Test
    void publishedEventsEmittedToExistingStreams() {
        Stream stream = this.testSubject.readEvents(null, true);
        this.testSubject.appendEvents(new EventMessage[]{TEST_EVENT});
        Assertions.assertTrue((boolean)stream.findFirst().isPresent());
    }

    @Test
    void publishedEventsEmittedToExistingStreams_WithOffset() {
        this.testSubject = new InMemoryEventStorageEngine(1L);
        Stream stream = this.testSubject.readEvents(null, true);
        this.testSubject.appendEvents(new EventMessage[]{TEST_EVENT});
        Optional optionalResult = stream.findFirst();
        Assertions.assertTrue((boolean)optionalResult.isPresent());
        OptionalLong optionalResultPosition = ((TrackedEventMessage)optionalResult.get()).trackingToken().position();
        Assertions.assertTrue((boolean)optionalResultPosition.isPresent());
        Assertions.assertEquals((long)1L, (long)optionalResultPosition.getAsLong());
    }

    @Test
    void eventsAreStoredOnCommitIfCurrentUnitOfWorkIsActive() {
        DefaultUnitOfWork unitOfWork = DefaultUnitOfWork.startAndGet(TEST_EVENT);
        this.testSubject.appendEvents(new EventMessage[]{TEST_EVENT});
        Stream eventStream = this.testSubject.readEvents(null, true);
        Assertions.assertEquals((long)0L, (long)eventStream.count());
        unitOfWork.commit();
        eventStream = this.testSubject.readEvents(null, true);
        Assertions.assertEquals((long)1L, (long)eventStream.count());
    }

    @Test
    void eventsAreNotStoredWhenTheUnitOfWorkIsRolledBackIfCurrentUnitOfWorkIsActive() {
        DefaultUnitOfWork unitOfWork = DefaultUnitOfWork.startAndGet(TEST_EVENT);
        this.testSubject.appendEvents(new EventMessage[]{TEST_EVENT});
        Stream eventStream = this.testSubject.readEvents(null, true);
        Assertions.assertEquals((long)0L, (long)eventStream.count());
        unitOfWork.rollback();
        eventStream = this.testSubject.readEvents(null, true);
        Assertions.assertEquals((long)0L, (long)eventStream.count());
    }
}

