/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStoreTest;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.HsqlEventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcEventStorageEngine;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.hsqldb.jdbc.JDBCDataSource;

class JdbcEmbeddedEventStoreTest
extends EmbeddedEventStoreTest {
    private JDBCDataSource dataSource;

    JdbcEmbeddedEventStoreTest() {
    }

    @Override
    public EventStorageEngine createStorageEngine() {
        Serializer testSerializer = TestSerializer.JACKSON.getSerializer();
        if (this.dataSource == null) {
            this.dataSource = new JDBCDataSource();
            this.dataSource.setUrl("jdbc:hsqldb:mem:test");
        }
        return this.createTables(JdbcEventStorageEngine.builder().eventSerializer(testSerializer).snapshotSerializer(testSerializer).connectionProvider(() -> ((JDBCDataSource)this.dataSource).getConnection()).transactionManager(this.transactionManager).build());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JdbcEventStorageEngine createTables(JdbcEventStorageEngine testEngine) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.prepareStatement("DROP TABLE IF EXISTS DomainEventEntry").executeUpdate();
            connection.prepareStatement("DROP TABLE IF EXISTS SnapshotEventEntry").executeUpdate();
            testEngine.createSchema((EventTableFactory)HsqlEventTableFactory.INSTANCE);
            JdbcEventStorageEngine jdbcEventStorageEngine = testEngine;
            return jdbcEventStorageEngine;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

