/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.sql.SQLException;
import org.axonframework.eventsourcing.eventstore.jpa.SQLStateResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SQLStateResolverTest {
    SQLStateResolverTest() {
    }

    @Test
    void defaultResolver_duplicateKeyException() {
        SQLStateResolver resolver = new SQLStateResolver();
        boolean isDuplicateKey = resolver.isDuplicateKeyViolation(this.duplicateKeyException());
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void defaultResolver_integrityConstraintViolated() {
        SQLStateResolver resolver = new SQLStateResolver();
        boolean isDuplicateKey = resolver.isDuplicateKeyViolation(this.integrityContraintViolation());
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void explicitResolver_duplicateKeyException() {
        SQLStateResolver resolver = new SQLStateResolver("23505");
        boolean isDuplicateKey = resolver.isDuplicateKeyViolation(this.duplicateKeyException());
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void explicitResolver_integrityConstraintViolated() {
        SQLStateResolver resolver = new SQLStateResolver("23505");
        boolean isDuplicateKey = resolver.isDuplicateKeyViolation(this.integrityContraintViolation());
        Assertions.assertFalse((boolean)isDuplicateKey, (String)"A general state code should not be matched by the explicitly configured resolver");
    }

    private Exception integrityContraintViolation() {
        return new SQLException("general state code", "23000");
    }

    private Exception duplicateKeyException() {
        return new SQLException("detailed state code", "23505");
    }
}

