/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.snapshotting;

import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.eventsourcing.snapshotting.RevisionSnapshotFilter;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RevisionSnapshotFilterTest {
    private static final String EXPECTED_REVISION = "LET ME IN";
    private final Serializer serializer = TestSerializer.xStreamSerializer();

    RevisionSnapshotFilterTest() {
    }

    @Test
    void allowsDomainEventDataContainingTheAllowedAggregateTypeAndRevision() {
        RevisionSnapshotFilter testSubject = RevisionSnapshotFilter.builder().type(RightAggregateTypeAndRevision.class.getSimpleName()).revision(EXPECTED_REVISION).build();
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage(RightAggregateTypeAndRevision.class.getName(), "some-aggregate-id", 0L, (Object)new RightAggregateTypeAndRevision("some-state"));
        SnapshotEventEntry testDomainEventData = new SnapshotEventEntry((DomainEventMessage)snapshotEvent, this.serializer);
        Assertions.assertTrue((boolean)testSubject.allow((DomainEventData)testDomainEventData));
    }

    @Test
    void allowsDomainEventDataContainingTheWrongAggregateTypeAndAllowedRevision() {
        RevisionSnapshotFilter testSubject = RevisionSnapshotFilter.builder().type(RightAggregateTypeAndRevision.class.getSimpleName()).revision(EXPECTED_REVISION).build();
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage(WrongAggregateType.class.getName(), "some-aggregate-id", 0L, (Object)new WrongAggregateType("some-state"));
        SnapshotEventEntry testDomainEventData = new SnapshotEventEntry((DomainEventMessage)snapshotEvent, this.serializer);
        Assertions.assertTrue((boolean)testSubject.allow((DomainEventData)testDomainEventData));
    }

    @Test
    void disallowsDomainEventDataContainingTheAllowedAggregateTypeAndWrongRevision() {
        RevisionSnapshotFilter testSubject = RevisionSnapshotFilter.builder().type(RightAggregateTypeAndWrongRevision.class).revision(EXPECTED_REVISION).build();
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage(RightAggregateTypeAndWrongRevision.class.getName(), "some-aggregate-id", 0L, (Object)new RightAggregateTypeAndWrongRevision("some-state"));
        SnapshotEventEntry testDomainEventData = new SnapshotEventEntry((DomainEventMessage)snapshotEvent, this.serializer);
        Assertions.assertFalse((boolean)testSubject.allow((DomainEventData)testDomainEventData));
    }

    @Test
    void buildWithNullOrEmptyTypeThrowsAxonConfigurationException() {
        RevisionSnapshotFilter.Builder builderTestSubject = RevisionSnapshotFilter.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.type(""));
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.type((String)null));
    }

    @Test
    void buildWithNullOrEmptyRevisionThrowsAxonConfigurationException() {
        RevisionSnapshotFilter.Builder builderTestSubject = RevisionSnapshotFilter.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.revision(""));
    }

    @Test
    void buildWithoutTypeThrowsAxonConfigurationException() {
        RevisionSnapshotFilter.Builder builderTestSubject = RevisionSnapshotFilter.builder().revision(EXPECTED_REVISION);
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((RevisionSnapshotFilter.Builder)builderTestSubject).build());
    }

    @Test
    void buildWithBlankRevisionThrowsAxonConfigurationException() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> RevisionSnapshotFilter.builder().type(RightAggregateTypeAndRevision.class).revision("").build());
    }

    @Revision(value="some-other-revision")
    private static class RightAggregateTypeAndWrongRevision {
        private final String state;

        private RightAggregateTypeAndWrongRevision(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }

    @Revision(value="some-other-revision")
    private static class WrongAggregateType {
        private final String state;

        private WrongAggregateType(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }

    @Revision(value="LET ME IN")
    private static class RightAggregateTypeAndRevision {
        private final String state;

        private RightAggregateTypeAndRevision(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }
}

