/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="RecordingAppender", category="Core", elementType="appender")
public class RecordingAppender
extends AbstractAppender {
    private static final Predicate<LogEvent> RECORDING_OFF = e -> false;
    private final List<LogEvent> logEvents = new CopyOnWriteArrayList<LogEvent>();
    private volatile Predicate<LogEvent> recordingFilter = RECORDING_OFF;

    protected RecordingAppender(String name, Filter filter) {
        super(name, filter, null, false, null);
    }

    @PluginFactory
    public static RecordingAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new RecordingAppender(name, filter);
    }

    public static RecordingAppender getInstance() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        return (RecordingAppender)configuration.getAppender("RECORD");
    }

    public void append(LogEvent event) {
        if (this.recordingFilter.test(event)) {
            this.logEvents.add(event.toImmutable());
        }
    }

    public void startRecording(Predicate<LogEvent> filter) {
        if (this.recordingFilter != RECORDING_OFF) {
            throw new IllegalStateException("Recording already started");
        }
        this.logEvents.clear();
        this.recordingFilter = filter;
    }

    public List<LogEvent> stopRecording() {
        this.recordingFilter = RECORDING_OFF;
        ArrayList<LogEvent> logs = new ArrayList<LogEvent>(this.logEvents);
        this.logEvents.clear();
        return logs;
    }
}

