/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Objects;
import java.util.function.Predicate;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;

public class EqualRevisionPredicate
implements Predicate<DomainEventData<?>> {
    private final RevisionResolver resolver;
    private final Serializer serializer;

    public EqualRevisionPredicate(RevisionResolver resolver, Serializer serializer) {
        this.resolver = resolver;
        this.serializer = serializer;
    }

    @Override
    public boolean test(DomainEventData<?> snapshot) {
        String aggregateRevision;
        SerializedType payloadType = snapshot.getPayload().getType();
        String payloadRevision = payloadType.getRevision();
        try {
            aggregateRevision = this.resolver.revisionOf(this.serializer.classForType(payloadType));
        }
        catch (Exception e) {
            return false;
        }
        return Objects.equals(payloadRevision, aggregateRevision);
    }
}

