/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public interface EventStorageEngine {
    default public void appendEvents(EventMessage<?> ... events) {
        this.appendEvents(Arrays.asList(events));
    }

    public void appendEvents(@Nonnull List<? extends EventMessage<?>> var1);

    public void storeSnapshot(@Nonnull DomainEventMessage<?> var1);

    public Stream<? extends TrackedEventMessage<?>> readEvents(@Nullable TrackingToken var1, boolean var2);

    default public DomainEventStream readEvents(@Nonnull String aggregateIdentifier) {
        return this.readEvents(aggregateIdentifier, 0L);
    }

    public DomainEventStream readEvents(@Nonnull String var1, long var2);

    public Optional<DomainEventMessage<?>> readSnapshot(@Nonnull String var1);

    default public Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        return this.readEvents(aggregateIdentifier).asStream().map(DomainEventMessage::getSequenceNumber).max(Long::compareTo);
    }

    default public TrackingToken createTailToken() {
        return null;
    }

    default public TrackingToken createHeadToken() {
        throw new UnsupportedOperationException("Creation of Head Token not supported by this EventStorageEngine");
    }

    default public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        throw new UnsupportedOperationException("Creation of Time based Token not supported by this EventStorageEngine");
    }
}

