/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.annotations.reflection;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.conversion.EventConverter;
import org.axonframework.eventsourcing.EventSourcedEntityFactory;
import org.axonframework.eventsourcing.annotations.reflection.EntityCreator;
import org.axonframework.eventsourcing.annotations.reflection.InjectEntityId;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageTypeResolver;
import org.axonframework.messaging.QualifiedName;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.annotations.ParameterResolverFactory;
import org.axonframework.messaging.annotations.PayloadParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.serialization.Converter;

public class AnnotationBasedEventSourcedEntityFactory<E, ID>
implements EventSourcedEntityFactory<ID, E> {
    private final Context.ResourceKey<ID> ID_KEY = Context.ResourceKey.withLabel((String)"EventSourcedEntityFactory.id");
    private final Class<E> entityType;
    private final Set<Class<? extends E>> types;
    private final Class<ID> idType;
    private final List<ScannedEntityCreator> creators = new ArrayList<ScannedEntityCreator>();
    private final IdTypeParameterResolver idTypeParameterResolver = new IdTypeParameterResolver();
    private final ParameterResolverFactory resolverFactory;
    private final MessageTypeResolver messageTypeResolver;
    private final EventConverter converter;

    public AnnotationBasedEventSourcedEntityFactory(@Nonnull Class<E> entityType, @Nonnull Class<ID> idType, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull EventConverter converter) {
        this(entityType, idType, Collections.emptySet(), parameterResolverFactory, messageTypeResolver, converter);
    }

    public AnnotationBasedEventSourcedEntityFactory(@Nonnull Class<E> entityType, @Nonnull Class<ID> idType, @Nonnull Set<Class<? extends E>> subTypes, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull EventConverter converter) {
        this.entityType = Objects.requireNonNull(entityType, "The entityType must not be null.");
        this.types = new HashSet<Class<Class<? extends E>>>(subTypes);
        this.types.add(entityType);
        this.idType = Objects.requireNonNull(idType, "The idType must not be null.");
        this.resolverFactory = Objects.requireNonNull(parameterResolverFactory, "The parameterResolverFactory must not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The messageTypeResolver must not be null.");
        this.converter = Objects.requireNonNull(converter, "The converter must not be null.");
        this.initialize();
    }

    private void initialize() {
        this.scanMethods();
        this.scanConstructors();
        this.validate();
    }

    private void scanConstructors() {
        this.types.stream().flatMap(type -> Arrays.stream(type.getDeclaredConstructors())).filter(constructor -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)constructor, EntityCreator.class)).distinct().forEach(this::addEntityCreatorExecutable);
    }

    private void scanMethods() {
        this.types.stream().flatMap(type -> StreamSupport.stream(ReflectionUtils.methodsOf((Class)type).spliterator(), false)).filter(method -> AnnotationUtils.isAnnotationPresent((AnnotatedElement)method, EntityCreator.class)).distinct().forEach(this::addEntityCreatorMethod);
    }

    private void validate() {
        if (this.creators.isEmpty()) {
            throw new AxonConfigurationException("No @EntityCreator present on entity of type [%s]. Can not initialize AnnotationBasedEventSourcedEntityFactory.".formatted(this.entityType.getName()));
        }
    }

    private void addEntityCreatorMethod(Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new AxonConfigurationException("Method-based @EntityCreator must be static. Found method: %s".formatted(method));
        }
        if (!this.entityType.isAssignableFrom(method.getReturnType())) {
            throw new AxonConfigurationException("Method-based @EntityCreator must return the entity type or a subtype. Found method: [%s]".formatted(method));
        }
        this.addEntityCreatorExecutable(method);
    }

    private void addEntityCreatorExecutable(Executable executable) {
        String[] payloadQualifiedNamesAttribute = AnnotationUtils.findAnnotationAttribute((AnnotatedElement)executable, EntityCreator.class, (String)"payloadQualifiedNames").map(o -> (String[])o).orElseThrow();
        List<QualifiedName> payloadQualifiedNames = Arrays.stream(payloadQualifiedNamesAttribute).map(QualifiedName::new).collect(Collectors.toList());
        ParameterResolver[] parameterResolvers = new ParameterResolver[executable.getParameterCount()];
        boolean hasMessageParameter = false;
        Class<ID> concreteIdType = null;
        Class expectedPayloadRepresentation = null;
        for (int i = 0; i < executable.getParameterCount(); ++i) {
            ParameterResolver instance;
            Class<?> parameterType = executable.getParameterTypes()[i];
            if (AnnotationUtils.isAnnotationPresent((AnnotatedElement)executable.getParameters()[i], InjectEntityId.class)) {
                if (concreteIdType != null && !concreteIdType.isAssignableFrom(parameterType)) {
                    throw new AxonConfigurationException("The @InjectEntityId annotation can only be used on a single parameter of type [%s] or a subtype. Found [%s] on parameter %d of method [%s]".formatted(concreteIdType, parameterType.getName(), i, executable));
                }
                parameterResolvers[i] = this.idTypeParameterResolver;
                concreteIdType = this.idType;
                continue;
            }
            if (Message.class.isAssignableFrom(parameterType)) {
                hasMessageParameter = true;
            }
            if ((instance = this.resolverFactory.createInstance(executable, executable.getParameters(), i)) == null) {
                throw new AxonConfigurationException("Could not resolve parameter [%d] of [%s]. No suitable ParameterResolver found for type [%s]".formatted(i, executable, parameterType.getName()));
            }
            if (instance instanceof PayloadParameterResolver) {
                PayloadParameterResolver payloadParameterResolver = (PayloadParameterResolver)instance;
                if (expectedPayloadRepresentation != null) {
                    throw new AxonConfigurationException("The method [%s] has multiple payload parameters".formatted(executable));
                }
                expectedPayloadRepresentation = payloadParameterResolver.supportedPayloadType();
            }
            parameterResolvers[i] = instance;
        }
        if (payloadQualifiedNames.isEmpty()) {
            Arrays.stream(parameterResolvers).filter(p -> p instanceof PayloadParameterResolver).findFirst().map(prr -> this.messageTypeResolver.resolveOrThrow(prr.supportedPayloadType())).ifPresent(messageType -> payloadQualifiedNames.add(messageType.qualifiedName()));
        }
        this.creators.add(new ScannedEntityCreator(executable, parameterResolvers, payloadQualifiedNames, concreteIdType, expectedPayloadRepresentation, hasMessageParameter));
    }

    private Set<ScannedEntityCreator> getMethodsCompatibleWithIdAndNoMessage(ID id) {
        return this.creators.stream().filter(method -> method.supportsId(id)).filter(ScannedEntityCreator::isWithoutPayload).collect(Collectors.toSet());
    }

    private Set<ScannedEntityCreator> getMethodsCompatibleWithIdAndMessage(ID id, EventMessage eventMessage) {
        return this.creators.stream().filter(creator -> creator.supportsId(id)).filter(creator -> creator.hasPayload(eventMessage.type().qualifiedName())).collect(Collectors.toSet());
    }

    private ScannedEntityCreator findMostSpecificMethod(ID id, EventMessage eventMessage, ProcessingContext context) {
        Set<ScannedEntityCreator> compatibleCreators;
        if (eventMessage != null) {
            compatibleCreators = this.getMethodsCompatibleWithIdAndMessage(id, eventMessage);
            if (compatibleCreators.isEmpty()) {
                compatibleCreators = this.getMethodsCompatibleWithIdAndNoMessage(id);
            }
        } else {
            compatibleCreators = this.getMethodsCompatibleWithIdAndNoMessage(id);
        }
        if (compatibleCreators.isEmpty()) {
            StringBuilder message = new StringBuilder("No suitable @EntityCreator found for id: [%s] and event message [%s]. Candidates were:".formatted(id, eventMessage));
            this.creators.forEach(creator -> message.append("\n - ").append(creator));
            throw new AxonConfigurationException(message.toString());
        }
        Set matchingCreators = compatibleCreators.stream().filter(e -> {
            ProcessingContext convertedContext = e.mapContextWithMessageIfNecessary(context);
            return e.parametersMatch(convertedContext);
        }).collect(Collectors.toSet());
        if (matchingCreators.isEmpty()) {
            StringBuilder message = new StringBuilder("No @EntityCreator matched for entity id: [%s] and event message [%s]. Candidates were:\n".formatted(id, eventMessage));
            for (ScannedEntityCreator compatibleCreator : compatibleCreators) {
                List<Integer> unresolvableParameterIndices = compatibleCreator.getUnresolvableParameterIndices(context);
                message.append(" - [%s] could not resolve parameters indices: %s\n".formatted(compatibleCreator, unresolvableParameterIndices));
            }
            message.append("\n\nPlease ensure that the parameters can be resolved by the ParameterResolverFactory implementations on the classpath.");
            throw new AxonConfigurationException(message.toString());
        }
        return matchingCreators.stream().max(Comparator.comparingInt(ScannedEntityCreator::getParameterCount)).orElseThrow();
    }

    @Override
    @Nullable
    public E create(@Nonnull ID id, @Nullable EventMessage firstEventMessage, @Nonnull ProcessingContext context) {
        ProcessingContext preparedContext = context.withResource(this.ID_KEY, id);
        if (firstEventMessage != null) {
            preparedContext = Message.addToContext((ProcessingContext)preparedContext, (Message)firstEventMessage);
        }
        return this.findMostSpecificMethod(id, firstEventMessage, preparedContext).invoke(id, preparedContext);
    }

    private class IdTypeParameterResolver
    implements ParameterResolver<ID> {
        private IdTypeParameterResolver() {
        }

        @Nullable
        public ID resolveParameterValue(@Nonnull ProcessingContext processingContext) {
            return processingContext.getResource(AnnotationBasedEventSourcedEntityFactory.this.ID_KEY);
        }

        public boolean matches(@Nonnull ProcessingContext processingContext) {
            return processingContext.containsResource(AnnotationBasedEventSourcedEntityFactory.this.ID_KEY);
        }
    }

    private class ScannedEntityCreator {
        private final Executable executable;
        private final ParameterResolver<?>[] parameterResolvers;
        private final List<QualifiedName> payloadQualifiedNames;
        private final Class<?> concreteIdType;
        private final Class<?> expectedPayloadRepresentation;
        private final boolean hasMessageParameter;

        private ScannedEntityCreator(Executable executable, ParameterResolver<?>[] parameterResolvers, List<QualifiedName> payloadQualifiedNames, Class<?> concreteIdType, Class<?> expectedPayloadRepresentation, boolean hasMessageParameter) {
            this.hasMessageParameter = hasMessageParameter;
            ReflectionUtils.ensureAccessible((AccessibleObject)executable);
            this.executable = executable;
            this.parameterResolvers = parameterResolvers;
            this.payloadQualifiedNames = payloadQualifiedNames;
            this.concreteIdType = concreteIdType;
            this.expectedPayloadRepresentation = expectedPayloadRepresentation;
        }

        private E invoke(ID id, ProcessingContext context) {
            ProcessingContext contextWithId = context.withResource(AnnotationBasedEventSourcedEntityFactory.this.ID_KEY, id);
            ProcessingContext convertedContext = this.mapContextWithMessageIfNecessary(contextWithId);
            Object[] args = new Object[this.executable.getParameterCount()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.parameterResolvers[i].resolveParameterValue(convertedContext);
            }
            return this.constructEntityWithArguments(args);
        }

        private boolean supportsId(ID id) {
            return this.concreteIdType == null || this.concreteIdType.isAssignableFrom(id.getClass());
        }

        private int getParameterCount() {
            return this.parameterResolvers.length;
        }

        private boolean parametersMatch(ProcessingContext processingContext) {
            return Arrays.stream(this.parameterResolvers).allMatch(f -> f.matches(processingContext));
        }

        private boolean isWithoutPayload() {
            return this.payloadQualifiedNames.isEmpty() && !this.hasMessageParameter;
        }

        private boolean hasPayload(QualifiedName qualifiedName) {
            if (this.payloadQualifiedNames.isEmpty()) {
                return this.hasMessageParameter;
            }
            return this.payloadQualifiedNames.contains(qualifiedName);
        }

        private E constructEntityWithArguments(Object[] args) {
            try {
                Executable executable = this.executable;
                Objects.requireNonNull(executable);
                Executable executable2 = executable;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Constructor.class, Method.class}, (Object)executable2, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Constructor c = (Constructor)executable2;
                        yield c.newInstance(args);
                    }
                    case 1 -> {
                        Method method = (Method)executable2;
                        yield method.invoke(null, args);
                    }
                };
            }
            catch (Exception e) {
                throw new AxonConfigurationException("Failed to invoke entity initializer", (Throwable)e);
            }
        }

        private List<Integer> getUnresolvableParameterIndices(ProcessingContext processingContext) {
            return StreamSupport.stream(Arrays.spliterator(this.parameterResolvers), false).filter(p -> !p.matches(processingContext)).map(p -> Arrays.asList(this.parameterResolvers).indexOf(p)).collect(Collectors.toList());
        }

        public String toString() {
            return ReflectionUtils.getMemberGenericString((Member)this.executable);
        }

        public ProcessingContext mapContextWithMessageIfNecessary(ProcessingContext context) {
            Message eventMessage = Message.fromContext((ProcessingContext)context);
            if (eventMessage != null && this.expectedPayloadRepresentation != null) {
                Message convertedEvent = eventMessage.withConvertedPayload(this.expectedPayloadRepresentation, (Converter)AnnotationBasedEventSourcedEntityFactory.this.converter);
                return Message.addToContext((ProcessingContext)context, (Message)convertedEvent);
            }
            return context;
        }
    }
}

