/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.configuration.ComponentRegistry;
import org.axonframework.configuration.Configuration;
import org.axonframework.configuration.ConfigurationEnhancer;
import org.axonframework.eventsourcing.eventstore.AnnotationBasedTagResolver;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.InterceptingEventStore;
import org.axonframework.eventsourcing.eventstore.SimpleEventStore;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.interceptors.DispatchInterceptorRegistry;

public class EventSourcingConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = 2147483547;

    public int order() {
        return 2147483547;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(TagResolver.class, EventSourcingConfigurationDefaults::defaultTagResolver).registerIfNotPresent(EventStorageEngine.class, EventSourcingConfigurationDefaults::defaultEventStorageEngine).registerIfNotPresent(EventStore.class, EventSourcingConfigurationDefaults::defaultEventStore);
        registry.registerDecorator(EventStore.class, -2147483598, (config, name, delegate) -> {
            List dispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).eventInterceptors(config);
            return dispatchInterceptors.isEmpty() ? delegate : new InterceptingEventStore((EventStore)delegate, dispatchInterceptors);
        });
    }

    private static TagResolver defaultTagResolver(Configuration configuration) {
        return new AnnotationBasedTagResolver();
    }

    private static EventStorageEngine defaultEventStorageEngine(Configuration config) {
        return new InMemoryEventStorageEngine();
    }

    private static EventStore defaultEventStore(Configuration config) {
        return new SimpleEventStore((EventStorageEngine)config.getComponent(EventStorageEngine.class), (TagResolver)config.getComponent(TagResolver.class));
    }
}

