/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.AggregateBasedConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.AppendEventsTransactionRejectedException;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.eventsourcing.eventstore.TooManyTagsOnEventMessageException;
import org.axonframework.eventstreaming.Tag;

public class AggregateBasedEventStorageEngineUtils {
    public static void assertValidTags(List<TaggedEventMessage<?>> events) {
        for (TaggedEventMessage<?> taggedEvent : events) {
            if (taggedEvent.tags().size() <= 1) continue;
            throw new TooManyTagsOnEventMessageException("An Event Storage engine in Aggregate mode does not support multiple tags per event", (EventMessage)taggedEvent.event(), taggedEvent.tags());
        }
    }

    @Nullable
    public static String resolveAggregateIdentifier(Set<Tag> tags) {
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1) {
            throw new IllegalArgumentException("Condition must provide exactly one tag");
        }
        return tags.iterator().next().value();
    }

    @Nullable
    public static String resolveAggregateType(Set<Tag> tags) {
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1) {
            throw new IllegalArgumentException("Condition must provide exactly one tag");
        }
        return tags.iterator().next().key();
    }

    public static Throwable translateConflictException(ConsistencyMarker consistencyMarker, Throwable e, Predicate<Throwable> isConflictException) {
        Throwable translatedCause;
        if (isConflictException.test(e)) {
            AppendEventsTransactionRejectedException translated = AppendEventsTransactionRejectedException.conflictingEventsDetected(consistencyMarker);
            translated.addSuppressed(e);
            return translated;
        }
        if (e.getCause() != null && (translatedCause = AggregateBasedEventStorageEngineUtils.translateConflictException(consistencyMarker, e.getCause(), isConflictException)) != e.getCause()) {
            return translatedCause;
        }
        return e;
    }

    private AggregateBasedEventStorageEngineUtils() {
    }

    public static final class AggregateSequencer {
        private final Map<String, AtomicLong> aggregateSequences;
        private AggregateBasedConsistencyMarker consistencyMarker;

        private AggregateSequencer(Map<String, AtomicLong> aggregateSequences, AggregateBasedConsistencyMarker consistencyMarker) {
            this.aggregateSequences = aggregateSequences;
            this.consistencyMarker = consistencyMarker;
        }

        public static AggregateSequencer with(AggregateBasedConsistencyMarker consistencyMarker) {
            return new AggregateSequencer(new HashMap<String, AtomicLong>(), consistencyMarker);
        }

        public AggregateBasedConsistencyMarker forwarded() {
            AggregateBasedConsistencyMarker newConsistencyMarker = this.consistencyMarker;
            for (Map.Entry<String, AtomicLong> aggSeq : this.aggregateSequences.entrySet()) {
                newConsistencyMarker = newConsistencyMarker.forwarded(aggSeq.getKey(), aggSeq.getValue().get());
            }
            this.consistencyMarker = newConsistencyMarker;
            return newConsistencyMarker;
        }

        public long incrementAndGetSequenceOf(String aggregateIdentifier) {
            AtomicLong aggregateSequence = this.aggregateSequences.computeIfAbsent(aggregateIdentifier, i -> new AtomicLong(this.consistencyMarker.positionOf((String)i)));
            return aggregateSequence.incrementAndGet();
        }
    }
}

