/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.ConsistencyMarker;
import org.axonframework.eventsourcing.eventstore.SourcingCondition;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public interface EventStorageEngine
extends DescribableComponent {
    default public CompletableFuture<AppendTransaction<?>> appendEvents(@Nonnull AppendCondition condition, @Nullable ProcessingContext context, TaggedEventMessage<?> ... events) {
        return this.appendEvents(condition, context, Arrays.asList(events));
    }

    public CompletableFuture<AppendTransaction<?>> appendEvents(@Nonnull AppendCondition var1, @Nullable ProcessingContext var2, @Nonnull List<TaggedEventMessage<?>> var3);

    public MessageStream<EventMessage> source(@Nonnull SourcingCondition var1, @Nullable ProcessingContext var2);

    public MessageStream<EventMessage> stream(@Nonnull StreamingCondition var1, @Nullable ProcessingContext var2);

    public CompletableFuture<TrackingToken> firstToken(@Nullable ProcessingContext var1);

    public CompletableFuture<TrackingToken> latestToken(@Nullable ProcessingContext var1);

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant var1, @Nullable ProcessingContext var2);

    public static interface AppendTransaction<R> {
        public CompletableFuture<R> commit(@Nullable ProcessingContext var1);

        public void rollback(@Nullable ProcessingContext var1);

        public CompletableFuture<ConsistencyMarker> afterCommit(R var1, @Nullable ProcessingContext var2);
    }
}

