/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventstreaming.Tag;

public class MultiTagResolver
implements TagResolver {
    private final List<? extends TagResolver> delegates;

    public MultiTagResolver(@Nonnull List<? extends TagResolver> tagResolvers) {
        this.delegates = List.copyOf(tagResolvers);
    }

    public MultiTagResolver(TagResolver ... tagResolvers) {
        this.delegates = List.of(tagResolvers);
    }

    @Override
    @Nonnull
    public Set<Tag> resolve(@Nonnull EventMessage event) {
        HashSet<Tag> tags = new HashSet<Tag>();
        for (TagResolver tagResolver : this.delegates) {
            tags.addAll(tagResolver.resolve(event));
        }
        return tags;
    }
}

