/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.processors.streaming.token.TrackingToken;
import org.axonframework.eventsourcing.eventstore.AppendCondition;
import org.axonframework.eventsourcing.eventstore.DefaultEventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.EventStoreTransaction;
import org.axonframework.eventsourcing.eventstore.GenericTaggedEventMessage;
import org.axonframework.eventsourcing.eventstore.TagResolver;
import org.axonframework.eventsourcing.eventstore.TaggedEventMessage;
import org.axonframework.eventstreaming.StreamingCondition;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.unitofwork.ProcessingContext;

public class SimpleEventStore
implements EventStore {
    private final EventStorageEngine eventStorageEngine;
    private final TagResolver tagResolver;
    private final Context.ResourceKey<EventStoreTransaction> eventStoreTransactionKey;

    public SimpleEventStore(@Nonnull EventStorageEngine eventStorageEngine, @Nonnull TagResolver tagResolver) {
        this.eventStorageEngine = eventStorageEngine;
        this.tagResolver = tagResolver;
        this.eventStoreTransactionKey = Context.ResourceKey.withLabel((String)"eventStoreTransaction");
    }

    @Override
    public EventStoreTransaction transaction(@Nonnull ProcessingContext processingContext) {
        return (EventStoreTransaction)processingContext.computeResourceIfAbsent(this.eventStoreTransactionKey, () -> new DefaultEventStoreTransaction(this.eventStorageEngine, processingContext, this::tagEvents));
    }

    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        if (context == null) {
            AppendCondition none = AppendCondition.none();
            ArrayList taggedEvents = new ArrayList();
            for (EventMessage event : events) {
                taggedEvents.add(this.tagEvents(event));
            }
            return ((CompletableFuture)((CompletableFuture)this.eventStorageEngine.appendEvents(none, context, taggedEvents).thenApply(SimpleEventStore::castTransaction)).thenApply(tx -> tx.commit(context).thenApply(v -> tx.afterCommit(v, context)))).thenApply(marker -> null);
        }
        this.appendToTransaction(context, events);
        return FutureUtils.emptyCompletedFuture();
    }

    private TaggedEventMessage<EventMessage> tagEvents(EventMessage event) {
        return new GenericTaggedEventMessage<EventMessage>(event, this.tagResolver.resolve(event));
    }

    private void appendToTransaction(ProcessingContext context, List<EventMessage> events) {
        EventStoreTransaction transaction = this.transaction(context);
        for (EventMessage event : events) {
            transaction.appendEvent(event);
        }
    }

    public CompletableFuture<TrackingToken> firstToken(@Nullable ProcessingContext context) {
        return this.eventStorageEngine.firstToken(context);
    }

    public CompletableFuture<TrackingToken> latestToken(@Nullable ProcessingContext context) {
        return this.eventStorageEngine.latestToken(context);
    }

    public CompletableFuture<TrackingToken> tokenAt(@Nonnull Instant at, @Nullable ProcessingContext context) {
        return this.eventStorageEngine.tokenAt(at, context);
    }

    public MessageStream<EventMessage> open(@Nonnull StreamingCondition condition, @Nullable ProcessingContext context) {
        return this.eventStorageEngine.stream(condition, context);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("eventStorageEngine", (Object)this.eventStorageEngine);
        descriptor.describeProperty("tagResolver", (Object)this.tagResolver);
    }

    private static EventStorageEngine.AppendTransaction<Object> castTransaction(EventStorageEngine.AppendTransaction<?> at) {
        return at;
    }
}

