/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.kafka.eventhandling.consumer;

import java.util.Collection;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.axonframework.common.Assert;
import org.axonframework.kafka.eventhandling.consumer.Buffer;
import org.axonframework.kafka.eventhandling.consumer.KafkaMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedKafkaMessageBuffer<E extends Comparable & KafkaMetadataProvider>
implements Buffer<E> {
    private static final Logger logger = LoggerFactory.getLogger(SortedKafkaMessageBuffer.class);
    private final ConcurrentSkipListSet<E> delegate;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    private final int capacity;
    private int count;

    public SortedKafkaMessageBuffer() {
        this(1000);
    }

    public SortedKafkaMessageBuffer(int capacity) {
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, () -> "Capacity may not be <= 0");
        this.delegate = new ConcurrentSkipListSet();
        this.lock = new ReentrantLock();
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
        this.capacity = capacity;
    }

    @Override
    public void put(E e) throws InterruptedException {
        Assert.notNull(e, () -> "Element may not be empty");
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            this.doPut(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Collection<E> c) throws InterruptedException {
        Assert.notNull(c, () -> "Element may not be empty");
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            for (Comparable e : c) {
                this.doPut(e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void doPut(E e) throws InterruptedException {
        while (this.count == this.capacity) {
            this.notFull.await();
        }
        this.add(e);
        if (logger.isDebugEnabled()) {
            logger.debug("buffer state after appending {}", e);
            for (Comparable message : this.delegate) {
                logger.debug("partition:{}, offset:{}, timestamp:{}, payload:{}", new Object[]{((KafkaMetadataProvider)((Object)message)).partition(), ((KafkaMetadataProvider)((Object)message)).offset(), ((KafkaMetadataProvider)((Object)message)).timestamp(), ((KafkaMetadataProvider)((Object)message)).value()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E removed = this.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("buffer state after removing {}", removed);
                for (Comparable message : this.delegate) {
                    logger.debug("partition:{}, offset:{}, timestamp:{}, payload:{}", new Object[]{((KafkaMetadataProvider)((Object)message)).partition(), ((KafkaMetadataProvider)((Object)message)).offset(), ((KafkaMetadataProvider)((Object)message)).value(), ((KafkaMetadataProvider)((Object)message)).timestamp()});
                }
            }
            E e = removed;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E e = this.remove();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Comparable comparable = this.count > 0 ? (Comparable)this.delegate.first() : null;
            return (E)comparable;
        }
        finally {
            lock.unlock();
        }
    }

    private void add(E x) {
        if (this.delegate.add(x)) {
            ++this.count;
            this.notEmpty.signal();
        }
    }

    private E remove() {
        Comparable x = (Comparable)this.delegate.pollFirst();
        if (x != null) {
            --this.count;
            this.notFull.signal();
        }
        return (E)x;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.count == 0;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.capacity - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.delegate.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        return "SortedKafkaMessageBuffer:" + this.delegate;
    }
}

