/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.common.BuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalRetryScheduler
implements RetryScheduler {
    private static final Logger logger = LoggerFactory.getLogger(IntervalRetryScheduler.class);
    private final int retryInterval;
    private final int maxRetryCount;
    private final ScheduledExecutorService retryExecutor;

    protected IntervalRetryScheduler(Builder builder) {
        builder.validate();
        this.retryInterval = builder.retryInterval;
        this.maxRetryCount = builder.maxRetryCount;
        this.retryExecutor = builder.retryExecutor;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean scheduleRetry(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures, Runnable dispatchTask) {
        int failureCount = failures.size();
        if (!this.isExplicitlyNonTransient(lastFailure) && failureCount <= this.maxRetryCount) {
            if (logger.isInfoEnabled()) {
                logger.info("Processing of Command [{}] resulted in an exception. Will retry {} more time(s)... Exception was {}, {}", new Object[]{commandMessage.getPayloadType().getSimpleName(), this.maxRetryCount - failureCount, lastFailure.getClass().getName(), lastFailure.getMessage()});
            }
            return this.scheduleRetry(dispatchTask, this.retryInterval);
        }
        if (failureCount >= this.maxRetryCount && logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception {} times. Giving up permanently. ", new Object[]{commandMessage.getPayloadType().getSimpleName(), failureCount, lastFailure});
        } else if (logger.isInfoEnabled()) {
            logger.info("Processing of Command [{}] resulted in an exception and will not be retried. ", (Object)commandMessage.getPayloadType().getSimpleName(), (Object)lastFailure);
        }
        return false;
    }

    protected boolean isExplicitlyNonTransient(Throwable failure) {
        return failure instanceof AxonNonTransientException || failure.getCause() != null && this.isExplicitlyNonTransient(failure.getCause());
    }

    private boolean scheduleRetry(Runnable commandDispatch, int interval) {
        try {
            this.retryExecutor.schedule(commandDispatch, (long)interval, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (RejectedExecutionException e) {
            return false;
        }
    }

    public static class Builder {
        private int retryInterval;
        private int maxRetryCount;
        private ScheduledExecutorService retryExecutor;

        public Builder retryInterval(int retryInterval) {
            this.assertPositive(retryInterval, "The retryInterval must be a positive number");
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder maxRetryCount(int maxRetryCount) {
            this.assertPositive(maxRetryCount, "The maxRetryCount must be a positive number");
            this.maxRetryCount = maxRetryCount;
            return this;
        }

        public Builder retryExecutor(ScheduledExecutorService retryExecutor) {
            BuilderUtils.assertNonNull(retryExecutor, "ScheduledExecutorService may not be null");
            this.retryExecutor = retryExecutor;
            return this;
        }

        public IntervalRetryScheduler build() {
            return new IntervalRetryScheduler(this);
        }

        protected void validate() throws AxonConfigurationException {
            this.assertPositive(this.retryInterval, "The retryInterval is a hard requirement and should be provided");
            this.assertPositive(this.maxRetryCount, "The maxRetryCount is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.retryExecutor, "The ScheduledExecutorService is a hard requirement and should be provided");
        }

        private void assertPositive(int integer, String exceptionDescription) {
            BuilderUtils.assertThat(integer, number -> number >= 0, exceptionDescription);
        }
    }
}

