/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.jpa;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.AbstractTokenEntry;
import org.axonframework.serialization.Serializer;

@Entity
@IdClass(value=PK.class)
public class TokenEntry
extends AbstractTokenEntry<byte[]> {
    @Id
    private String processorName;
    @Id
    private int segment;

    public TokenEntry(String processorName, int segment, TrackingToken token, Serializer serializer) {
        super(token, serializer, byte[].class);
        this.processorName = processorName;
        this.segment = segment;
    }

    protected TokenEntry() {
    }

    @Override
    public void updateToken(TrackingToken token, Serializer serializer) {
        this.updateToken(token, serializer, byte[].class);
    }

    @Override
    public String getProcessorName() {
        return this.processorName;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public static class PK
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String processorName;
        private int segment;

        protected PK() {
        }

        public PK(String processorName, int segment) {
            this.processorName = processorName;
            this.segment = segment;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.segment == pk.segment && Objects.equals(this.processorName, pk.processorName);
        }

        public int hashCode() {
            return Objects.hash(this.processorName, this.segment);
        }
    }
}

