/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor<T extends Message<?>>
implements MessageHandlerInterceptor<T> {
    private final Logger logger;

    public LoggingInterceptor(String loggerName) {
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    public LoggingInterceptor() {
        this.logger = LoggerFactory.getLogger(LoggingInterceptor.class);
    }

    @Override
    public Object handle(UnitOfWork<? extends T> unitOfWork, InterceptorChain interceptorChain) throws Exception {
        T message = unitOfWork.getMessage();
        this.logger.info("Incoming message: [{}]", (Object)message.getPayloadType().getSimpleName());
        try {
            Object returnValue = interceptorChain.proceed();
            this.logger.info("[{}] executed successfully with a [{}] return value", (Object)message.getPayloadType().getSimpleName(), (Object)(returnValue == null ? "null" : returnValue.getClass().getSimpleName()));
            return returnValue;
        }
        catch (Exception t) {
            this.logger.warn(String.format("[%s] execution failed:", message.getPayloadType().getSimpleName()), (Throwable)t);
            throw t;
        }
    }
}

