/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnitOfWork<T extends Message<?>>
implements UnitOfWork<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractUnitOfWork.class);
    private final Map<String, Object> resources = new HashMap<String, Object>();
    private final Collection<CorrelationDataProvider> correlationDataProviders = new LinkedHashSet<CorrelationDataProvider>();
    private UnitOfWork<?> parentUnitOfWork;
    private UnitOfWork.Phase phase = UnitOfWork.Phase.NOT_STARTED;
    private boolean rolledBack;

    @Override
    public void start() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting Unit Of Work");
        }
        Assert.state(UnitOfWork.Phase.NOT_STARTED.equals((Object)this.phase()), () -> "UnitOfWork is already started");
        this.rolledBack = false;
        this.onRollback(u -> {
            this.rolledBack = true;
        });
        CurrentUnitOfWork.ifStarted(parent -> {
            this.parentUnitOfWork = parent;
            this.root().onCleanup(r -> this.changePhase(UnitOfWork.Phase.CLEANUP, UnitOfWork.Phase.CLOSED));
        });
        this.changePhase(UnitOfWork.Phase.STARTED);
        CurrentUnitOfWork.set(this);
    }

    @Override
    public void commit() {
        if (logger.isDebugEnabled()) {
            logger.debug("Committing Unit Of Work");
        }
        Assert.state(this.phase() == UnitOfWork.Phase.STARTED, () -> String.format("The UnitOfWork is in an incompatible phase: %s", new Object[]{this.phase()}));
        Assert.state(this.isCurrent(), () -> "The UnitOfWork is not the current Unit of Work");
        try {
            if (this.isRoot()) {
                this.commitAsRoot();
            } else {
                this.commitAsNested();
            }
        }
        finally {
            CurrentUnitOfWork.clear(this);
        }
    }

    private void commitAsRoot() {
        try {
            try {
                this.changePhase(UnitOfWork.Phase.PREPARE_COMMIT, UnitOfWork.Phase.COMMIT);
            }
            catch (Exception e) {
                this.setRollbackCause(e);
                this.changePhase(UnitOfWork.Phase.ROLLBACK);
                throw e;
            }
            if (this.phase() == UnitOfWork.Phase.COMMIT) {
                this.changePhase(UnitOfWork.Phase.AFTER_COMMIT);
            }
        }
        catch (Throwable throwable) {
            this.changePhase(UnitOfWork.Phase.CLEANUP, UnitOfWork.Phase.CLOSED);
            throw throwable;
        }
        this.changePhase(UnitOfWork.Phase.CLEANUP, UnitOfWork.Phase.CLOSED);
    }

    private void commitAsNested() {
        try {
            this.changePhase(UnitOfWork.Phase.PREPARE_COMMIT, UnitOfWork.Phase.COMMIT);
            this.delegateAfterCommitToParent(this);
            this.parentUnitOfWork.onRollback(u -> this.changePhase(UnitOfWork.Phase.ROLLBACK));
        }
        catch (Exception e) {
            this.setRollbackCause(e);
            this.changePhase(UnitOfWork.Phase.ROLLBACK);
            throw e;
        }
    }

    private void delegateAfterCommitToParent(UnitOfWork<?> uow) {
        Optional<UnitOfWork<?>> parent = uow.parent();
        if (parent.isPresent()) {
            parent.get().afterCommit(this::delegateAfterCommitToParent);
        } else {
            this.changePhase(UnitOfWork.Phase.AFTER_COMMIT);
        }
    }

    @Override
    public void rollback(Throwable cause) {
        if (logger.isDebugEnabled()) {
            logger.debug("Rolling back Unit Of Work.", cause);
        }
        Assert.state(this.isActive() && this.phase().isBefore(UnitOfWork.Phase.ROLLBACK), () -> String.format("The UnitOfWork is in an incompatible phase: %s", new Object[]{this.phase()}));
        Assert.state(this.isCurrent(), () -> "The UnitOfWork is not the current Unit of Work");
        try {
            this.setRollbackCause(cause);
            this.changePhase(UnitOfWork.Phase.ROLLBACK);
            if (this.isRoot()) {
                this.changePhase(UnitOfWork.Phase.CLEANUP, UnitOfWork.Phase.CLOSED);
            }
        }
        finally {
            CurrentUnitOfWork.clear(this);
        }
    }

    @Override
    public Optional<UnitOfWork<?>> parent() {
        return Optional.ofNullable(this.parentUnitOfWork);
    }

    @Override
    public Map<String, Object> resources() {
        return this.resources;
    }

    @Override
    public boolean isRolledBack() {
        return this.rolledBack;
    }

    @Override
    public void registerCorrelationDataProvider(CorrelationDataProvider correlationDataProvider) {
        this.correlationDataProviders.add(correlationDataProvider);
    }

    @Override
    public MetaData getCorrelationData() {
        if (this.correlationDataProviders.isEmpty()) {
            return MetaData.emptyInstance();
        }
        HashMap result = new HashMap();
        for (CorrelationDataProvider correlationDataProvider : this.correlationDataProviders) {
            Map<String, ?> extraData = correlationDataProvider.correlationDataFor((Message<?>)this.getMessage());
            if (extraData == null) continue;
            result.putAll(extraData);
        }
        return MetaData.from(result);
    }

    @Override
    public void onPrepareCommit(Consumer<UnitOfWork<T>> handler) {
        this.addHandler(UnitOfWork.Phase.PREPARE_COMMIT, handler);
    }

    @Override
    public void onCommit(Consumer<UnitOfWork<T>> handler) {
        this.addHandler(UnitOfWork.Phase.COMMIT, handler);
    }

    @Override
    public void afterCommit(Consumer<UnitOfWork<T>> handler) {
        this.addHandler(UnitOfWork.Phase.AFTER_COMMIT, handler);
    }

    @Override
    public void onRollback(Consumer<UnitOfWork<T>> handler) {
        this.addHandler(UnitOfWork.Phase.ROLLBACK, handler);
    }

    @Override
    public void onCleanup(Consumer<UnitOfWork<T>> handler) {
        this.addHandler(UnitOfWork.Phase.CLEANUP, handler);
    }

    @Override
    public UnitOfWork.Phase phase() {
        return this.phase;
    }

    protected void setPhase(UnitOfWork.Phase phase) {
        this.phase = phase;
    }

    protected void changePhase(UnitOfWork.Phase ... phases) {
        for (UnitOfWork.Phase phase : phases) {
            this.setPhase(phase);
            this.notifyHandlers(phase);
        }
    }

    protected Collection<CorrelationDataProvider> correlationDataProviders() {
        return this.correlationDataProviders;
    }

    protected abstract void notifyHandlers(UnitOfWork.Phase var1);

    protected abstract void addHandler(UnitOfWork.Phase var1, Consumer<UnitOfWork<T>> var2);

    protected abstract void setExecutionResult(ExecutionResult var1);

    protected abstract void setRollbackCause(Throwable var1);
}

