/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandBusSpanFactory;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DefaultCommandBusSpanFactory;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.MonitorAwareCallback;
import org.axonframework.commandhandling.NoHandlerForCommandException;
import org.axonframework.commandhandling.callbacks.LoggingCallback;
import org.axonframework.commandhandling.distributed.CommandBusConnector;
import org.axonframework.commandhandling.distributed.CommandDispatchException;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.CommandRouter;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.commandfilter.CommandNameFilter;
import org.axonframework.commandhandling.distributed.commandfilter.DenyAll;
import org.axonframework.commandhandling.distributed.commandfilter.DenyCommandNameFilter;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.Registration;
import org.axonframework.lifecycle.Lifecycle;
import org.axonframework.messaging.Distributed;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitor;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedCommandBus
implements CommandBus,
Distributed<CommandBus>,
Lifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int INITIAL_LOAD_FACTOR = 100;
    private static final String DISPATCH_ERROR_MESSAGE = "An error occurred while trying to dispatch a command on the DistributedCommandBus";
    private final CommandRouter commandRouter;
    private final CommandBusConnector connector;
    private final MessageMonitor<? super CommandMessage<?>> messageMonitor;
    private final List<MessageDispatchInterceptor<? super CommandMessage<?>>> dispatchInterceptors = new CopyOnWriteArrayList();
    private final AtomicReference<CommandMessageFilter> commandFilter = new AtomicReference<DenyAll>(DenyAll.INSTANCE);
    private final CommandCallback<Object, Object> defaultCommandCallback;
    private final CommandBusSpanFactory spanFactory;
    private volatile int loadFactor = 100;

    public static Builder builder() {
        return new Builder();
    }

    protected DistributedCommandBus(Builder builder) {
        builder.validate();
        this.commandRouter = builder.commandRouter;
        this.connector = builder.connector;
        this.messageMonitor = builder.messageMonitor;
        this.defaultCommandCallback = builder.defaultCommandCallback;
        this.spanFactory = builder.spanFactory;
    }

    public void disconnect() {
        this.commandRouter.updateMembership(this.loadFactor, DenyAll.INSTANCE);
    }

    public CompletableFuture<Void> shutdownDispatching() {
        return this.connector.initiateShutdown();
    }

    @Override
    public void registerLifecycleHandlers(@Nonnull Lifecycle.LifecycleRegistry handle) {
        handle.onShutdown(0x1FFFFFFF, this::disconnect);
        handle.onShutdown(0, this::shutdownDispatching);
    }

    @Override
    public <C> void dispatch(@Nonnull CommandMessage<C> command) {
        logger.debug("Dispatch command [{}] with callback", (Object)command.getCommandName());
        this.dispatch(command, this.defaultCommandCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C, R> void dispatch(@Nonnull CommandMessage<C> command, @Nonnull CommandCallback<? super C, ? super R> callback) {
        block20: {
            CommandMessage<C> interceptedCommand = this.intercept(command);
            MessageMonitor.MonitorCallback messageMonitorCallback = this.messageMonitor.onMessageIngested(interceptedCommand);
            Optional<Member> optionalDestination = this.commandRouter.findDestination(interceptedCommand);
            Span span = this.spanFactory.createDispatchCommandSpan(command, true).start();
            try (SpanScope ignored = span.makeCurrent();){
                if (optionalDestination.isPresent()) {
                    Member destination = optionalDestination.get();
                    this.connector.send(destination, this.spanFactory.propagateContext(interceptedCommand), new MonitorAwareCallback<C, R>(callback, messageMonitorCallback));
                    break block20;
                }
                throw new NoHandlerForCommandException(String.format("No node known to accept command [%s].", interceptedCommand.getCommandName()));
            }
            catch (Exception e) {
                span.recordException(e);
                messageMonitorCallback.reportFailure(e);
                optionalDestination.ifPresent(Member::suspect);
                if (e instanceof NoHandlerForCommandException) {
                    callback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(e));
                } else {
                    callback.onResult(interceptedCommand, GenericCommandResultMessage.asCommandResultMessage(new CommandDispatchException("An error occurred while trying to dispatch a command on the DistributedCommandBus: " + e.getMessage(), e)));
                }
            }
            finally {
                span.end();
            }
        }
    }

    private <C> CommandMessage<? extends C> intercept(CommandMessage<C> command) {
        CommandMessage<C> interceptedCommand = command;
        for (MessageDispatchInterceptor<CommandMessage<?>> interceptor : this.dispatchInterceptors) {
            interceptedCommand = interceptor.handle(interceptedCommand);
        }
        return interceptedCommand;
    }

    @Override
    public Registration subscribe(@Nonnull String commandName, @Nonnull MessageHandler<? super CommandMessage<?>> handler) {
        logger.debug("Subscribing command with name [{}] to this distributed CommandBus. Expect similar logging on the local segment.", (Object)commandName);
        Registration reg = this.connector.subscribe(commandName, handler);
        this.updateFilter(this.commandFilter.get().or(new CommandNameFilter(commandName)));
        return () -> {
            this.updateFilter(this.commandFilter.get().and(new DenyCommandNameFilter(commandName)));
            return reg.cancel();
        };
    }

    private void updateFilter(CommandMessageFilter newFilter) {
        if (!this.commandFilter.getAndSet(newFilter).equals(newFilter)) {
            this.commandRouter.updateMembership(this.loadFactor, newFilter);
        }
    }

    @Override
    public CommandBus localSegment() {
        return this.connector.localSegment().orElse(this);
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void updateLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
        this.commandRouter.updateMembership(loadFactor, this.commandFilter.get());
    }

    @Override
    public Registration registerDispatchInterceptor(@Nonnull MessageDispatchInterceptor<? super CommandMessage<?>> dispatchInterceptor) {
        this.dispatchInterceptors.add(dispatchInterceptor);
        return () -> this.dispatchInterceptors.remove(dispatchInterceptor);
    }

    @Override
    public Registration registerHandlerInterceptor(@Nonnull MessageHandlerInterceptor<? super CommandMessage<?>> handlerInterceptor) {
        return this.connector.registerHandlerInterceptor(handlerInterceptor);
    }

    public static class Builder {
        private CommandCallback<Object, Object> defaultCommandCallback = LoggingCallback.INSTANCE;
        private CommandRouter commandRouter;
        private CommandBusConnector connector;
        private MessageMonitor<? super CommandMessage<?>> messageMonitor = NoOpMessageMonitor.INSTANCE;
        private CommandBusSpanFactory spanFactory = DefaultCommandBusSpanFactory.builder().spanFactory(NoOpSpanFactory.INSTANCE).build();

        public Builder commandRouter(CommandRouter commandRouter) {
            BuilderUtils.assertNonNull(commandRouter, "CommandRouter may not be null");
            this.commandRouter = commandRouter;
            return this;
        }

        public Builder connector(CommandBusConnector connector) {
            BuilderUtils.assertNonNull(connector, "CommandBusConnector may not be null");
            this.connector = connector;
            return this;
        }

        public Builder messageMonitor(MessageMonitor<? super CommandMessage<?>> messageMonitor) {
            BuilderUtils.assertNonNull(messageMonitor, "MessageMonitor may not be null");
            this.messageMonitor = messageMonitor;
            return this;
        }

        public Builder defaultCommandCallback(CommandCallback<Object, Object> defaultCommandCallback) {
            BuilderUtils.assertNonNull(defaultCommandCallback, "CommandCallback may not be null");
            this.defaultCommandCallback = defaultCommandCallback;
            return this;
        }

        @Deprecated
        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = DefaultCommandBusSpanFactory.builder().spanFactory(spanFactory).build();
            return this;
        }

        public Builder spanFactory(@Nonnull CommandBusSpanFactory spanFactory) {
            BuilderUtils.assertNonNull(spanFactory, "SpanFactory may not be null");
            this.spanFactory = spanFactory;
            return this;
        }

        public DistributedCommandBus build() {
            return new DistributedCommandBus(this);
        }

        protected void validate() {
            BuilderUtils.assertNonNull(this.commandRouter, "The CommandRouter is a hard requirement and should be provided");
            BuilderUtils.assertNonNull(this.connector, "The CommandBusConnector is a hard requirement and should be provided");
        }
    }
}

