/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.pooled;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CompletableFuture<Boolean> result;
    private final String name;

    protected CoordinatorTask(CompletableFuture<Boolean> result, String name) {
        this.result = result;
        this.name = name;
    }

    CompletableFuture<Boolean> run() {
        try {
            this.task().whenComplete(this::complete);
        }
        catch (Exception e) {
            this.complete(null, e);
        }
        return this.result;
    }

    protected abstract CompletableFuture<Boolean> task();

    void complete(Boolean outcome, Throwable throwable) {
        if (throwable != null) {
            logger.warn("Processor [{}] failed to run instruction - {}.", new Object[]{this.name, this.getDescription(), throwable});
            this.result.completeExceptionally(throwable);
        } else {
            this.result.complete(outcome);
        }
    }

    abstract String getDescription();
}

