/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Predicate;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.gateway.AbstractRetryScheduler;
import org.axonframework.commandhandling.gateway.AxonNonTransientExceptionClassesPredicate;
import org.axonframework.commandhandling.gateway.NonTransientExceptionClassesPredicate;
import org.axonframework.common.AxonNonTransientException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AbstractRetrySchedulerTest {
    @Test
    void isExplicitlyNonTransient_defaults() {
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).build();
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient((Throwable)new AxonNonTransientException("message"){}), (String)"AxonNonTransientException should be treated as non-transient by default");
    }

    @Test
    void isExplicitlyNonTransient_defaults_and_addNonTransientFailures() {
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).addNonTransientFailurePredicate((Predicate)new NonTransientExceptionClassesPredicate(new Class[]{CommandExecutionException.class, IllegalArgumentException.class}))).build();
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient((Throwable)new AxonNonTransientException("message"){}), (String)"AxonNonTransientException should be treated as non-transient by default");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new CommandExecutionException("message", null)), (String)"Per configuration, CommandExecutionException should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("message", null)), (String)"Per configuration, IllegalArgumentException should be treated as non-transient");
    }

    @Test
    void isExplicitlyNonTransient_nonTransientFailurePredicate_throwable() {
        Predicate<Throwable> nonTransientFailurePredicate = failure -> "I'm non-transient failure".equals(failure.getMessage());
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).nonTransientFailurePredicate(nonTransientFailurePredicate)).build();
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new Exception()), (String)"Per configuration, failures without appropriate message are not considered as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new Exception("a message")), (String)"Per configuration, failures without appropriate message are not considered as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new Exception("I'm non-transient failure")), (String)"Per configuration, only failures with appropriate message should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new RuntimeException("a message", new NullPointerException("I'm non-transient failure"))), (String)"Per configuration, only failures with appropriate message should be treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new Exception("a message", new IllegalArgumentException("a message"))), (String)"Per configuration, failures without appropriate message are not considered as non-transient");
    }

    @Test
    void isExplicitlyNonTransient_nonTransientFailurePredicate_generics() {
        Predicate<IllegalArgumentException> nonTransientFailurePredicate = failure -> "I'm non-transient IllegalArgumentException failure".equals(failure.getMessage());
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).nonTransientFailurePredicate(IllegalArgumentException.class, nonTransientFailurePredicate)).build();
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException()), (String)"Per configuration, IllegalArgumentException is transient only if their message says so");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("something")), (String)"Per configuration, IllegalArgumentException is transient only if their message says so");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("I'm non-transient IllegalArgumentException failure")), (String)"Per configuration, IllegalArgumentException with \"I'm non-transient IllegalArgumentException failure\" message should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("message", new IllegalArgumentException("I'm non-transient IllegalArgumentException failure"))), (String)"Per configuration, IllegalArgumentException with \"I'm non-transient IllegalArgumentException failure\" message should be treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new RuntimeException()), (String)"Per configuration, only IllegalArgumentException with appropriate message is treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("a message", new RuntimeException())), (String)"Per configuration, only IllegalArgumentException with appropriate message is treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new CommandExecutionException(null, null)), (String)"Per configuration, only IllegalArgumentException with appropriate message is treated as non-transient");
    }

    @Test
    void isExplicitlyNonTransient_nonTransientFailurePredicate_and_addNonTransientFailures() {
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).nonTransientFailurePredicate((Predicate)new AxonNonTransientExceptionClassesPredicate())).addNonTransientFailurePredicate((Predicate)new NonTransientExceptionClassesPredicate(new Class[]{CommandExecutionException.class, IllegalArgumentException.class}))).build();
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient((Throwable)new AxonNonTransientException("message"){}), (String)"Per configuration, AxonNonTransientException should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new CommandExecutionException("message", null)), (String)"Per configuration, CommandExecutionException should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("message", null)), (String)"Per configuration, IllegalArgumentException should be treated as non-transient");
    }

    @Test
    void isExplicitlyNonTransient_typicalUsageDemo() {
        Predicate<CommandExecutionException> nonTransientCommandExecutionExceptionPredicate = failure -> Objects.equals(failure.getDetails().orElse("transient"), "I'm non-transient");
        RetrySchedulerStub retrySchedulerStub = ((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)((RetrySchedulerStub.Builder)RetrySchedulerStub.builder().retryExecutor((ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class))).nonTransientFailurePredicate((Predicate)new NonTransientExceptionClassesPredicate(new Class[]{AxonNonTransientException.class, NullPointerException.class, IllegalArgumentException.class, IllegalStateException.class}))).addNonTransientFailurePredicate(CommandExecutionException.class, nonTransientCommandExecutionExceptionPredicate)).build();
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new CommandExecutionException("failure", null, (Object)"I'm non-transient")), (String)"Per configuration, CommandExecutionException with appropriate details should be treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new CommandExecutionException("failure", null, (Object)"a details")), (String)"Per configuration, CommandExecutionException with unexpected details should be treated as transient");
        CommandExecutionException extendedFromCommandExecutionException = new CommandExecutionException("failure", null, "I'm non-transient"){};
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(extendedFromCommandExecutionException), (String)"Per configuration, CommandExecutionException descendants, with appropriate message, should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new NullPointerException("a null")), (String)"Per configuration, NullPointerException should be treated as non-transient");
        Assertions.assertTrue((boolean)retrySchedulerStub.isExplicitlyNonTransient(new IllegalArgumentException("illegal")), (String)"Per configuration, IllegalArgumentException should be treated as non-transient");
        Assertions.assertFalse((boolean)retrySchedulerStub.isExplicitlyNonTransient(new RuntimeException("runtime problem")), (String)"Per configuration, RuntimeException should be treated as a transient failure");
    }

    public static class RetrySchedulerStub
    extends AbstractRetryScheduler {
        protected RetrySchedulerStub(Builder builder) {
            super((AbstractRetryScheduler.Builder)builder);
        }

        protected long computeRetryInterval(CommandMessage commandMessage, RuntimeException lastFailure, List<Class<? extends Throwable>[]> failures) {
            return 100L;
        }

        static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends AbstractRetryScheduler.Builder<Builder> {
            RetrySchedulerStub build() {
                return new RetrySchedulerStub(this);
            }
        }
    }
}

