/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import org.axonframework.common.property.AbstractPropertyAccessStrategyTest;
import org.axonframework.common.property.BeanPropertyAccessStrategy;
import org.axonframework.common.property.Property;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyAccessStrategyTest
extends AbstractPropertyAccessStrategyTest<TestMessage> {
    private static final Logger log = LoggerFactory.getLogger(BeanPropertyAccessStrategyTest.class);

    @Override
    protected String exceptionPropertyName() {
        return "exceptionProperty";
    }

    @Override
    protected String regularPropertyName() {
        return "actualProperty";
    }

    @Override
    protected String unknownPropertyName() {
        return "bogusProperty";
    }

    @Override
    protected TestMessage propertyHoldingInstance() {
        return new TestMessage();
    }

    @Override
    protected Property<TestMessage> getProperty(String property) {
        return new BeanPropertyAccessStrategy().propertyFor(TestMessage.class, property);
    }

    void testPerformanceWhenMethodNotExisting() {
        BeanPropertyAccessStrategy beanPropertyAccess = new BeanPropertyAccessStrategy();
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            beanPropertyAccess.propertyFor(TestMessage.class, "notExistingProperty" + i);
        }
        long end = System.currentTimeMillis();
        log.info("Used time: {} millis", (Object)(end - start));
    }

    @Override
    protected String voidPropertyName() {
        return "voidMethod";
    }

    class TestMessage {
        TestMessage() {
        }

        public String getActualProperty() {
            return "propertyValue";
        }

        public String getExceptionProperty() {
            throw new RuntimeException("GetTestException");
        }

        public void getVoidMethod() {
            Assertions.fail((String)"This method should never be invoked");
        }
    }
}

