/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import org.axonframework.deadline.TestScopeDescriptor;
import org.axonframework.deadline.jobrunr.LabelUtils;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LabelUtilsTest {
    LabelUtilsTest() {
    }

    @Test
    void forShortStringLabelShouldBeSameAsInput() {
        String expected = "short";
        Assertions.assertEquals((Object)expected, (Object)LabelUtils.getLabel((String)expected));
    }

    @Test
    void forLongStringLabelShouldBeConsistentButShorter() {
        String longString = "shortsadfsdfsdfsdfsdfsdfsafdsfdgdgdgdgfgfdgdfgdfsfdsfsdfdsfdsfsdfdssdjklfisdfikusdufidsufsdfdsufsifsfsfsdfgdfdfgfgdfgdfgdfs";
        String expected = LabelUtils.getLabel((String)longString);
        Assertions.assertEquals((Object)expected, (Object)LabelUtils.getLabel((String)longString));
        Assertions.assertTrue((longString.length() > expected.length() ? 1 : 0) != 0);
    }

    @Test
    void combinedScopeShouldBeConsistentAndShorterThan45Characters() {
        String deadLineName = "deadlineName";
        Serializer serializer = TestSerializer.JACKSON.getSerializer();
        TestScopeDescriptor descriptor = new TestScopeDescriptor("aggregateType", "identifier");
        String expected = LabelUtils.getCombinedLabel((Serializer)serializer, (String)deadLineName, (ScopeDescriptor)descriptor);
        Assertions.assertEquals((Object)expected, (Object)LabelUtils.getCombinedLabel((Serializer)serializer, (String)deadLineName, (ScopeDescriptor)descriptor));
        Assertions.assertTrue((expected.length() < 45 ? 1 : 0) != 0);
    }
}

