/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.Instant;
import java.time.temporal.Temporal;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.Timestamp;
import org.axonframework.eventhandling.TimestampParameterResolverFactory;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TimestampParameterResolverFactoryTest {
    private TimestampParameterResolverFactory testSubject;
    private Method instantMethod;
    private Method temporalMethod;
    private Method stringMethod;
    private Method nonAnnotatedInstantMethod;
    private Method metaAnnotatedMethod;

    TimestampParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new TimestampParameterResolverFactory();
        this.instantMethod = this.getClass().getMethod("someInstantMethod", Instant.class);
        this.metaAnnotatedMethod = this.getClass().getMethod("someMetaAnnotatedInstantMethod", Instant.class);
        this.nonAnnotatedInstantMethod = this.getClass().getMethod("someNonAnnotatedInstantMethod", Instant.class);
        this.temporalMethod = this.getClass().getMethod("someTemporalMethod", Temporal.class);
        this.stringMethod = this.getClass().getMethod("someStringMethod", String.class);
    }

    public void someInstantMethod(@Timestamp Instant timestamp) {
    }

    public void someMetaAnnotatedInstantMethod(@CustomTimestamp Instant timestamp) {
    }

    public void someNonAnnotatedInstantMethod(Instant timestamp) {
    }

    public void someTemporalMethod(@Timestamp Temporal timestamp) {
    }

    public void someStringMethod(@Timestamp String timestamp) {
    }

    @Test
    void resolvesToDateTimeWhenAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.instantMethod, this.instantMethod.getParameters(), 0);
        EventMessage message = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)message));
        Assertions.assertEquals((Object)message.getTimestamp(), (Object)resolver.resolveParameterValue((Message)message));
    }

    @Test
    void resolvesToReadableInstantWhenAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.temporalMethod, this.temporalMethod.getParameters(), 0);
        EventMessage message = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)message));
        Assertions.assertEquals((Object)message.getTimestamp(), (Object)resolver.resolveParameterValue((Message)message));
    }

    @Test
    void ignoredWhenNotAnnotated() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.nonAnnotatedInstantMethod, this.nonAnnotatedInstantMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void ignoredWhenWrongType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.stringMethod, this.stringMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver);
    }

    @Test
    void resolvesToDateTimeWhenAnnotatedWithMetaAnnotation() {
        Parameter[] parameters = this.metaAnnotatedMethod.getParameters();
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.metaAnnotatedMethod, parameters, 0);
        EventMessage message = GenericEventMessage.asEventMessage((Object)"test");
        Assertions.assertTrue((boolean)resolver.matches((Message)message), (String)("Resolver should be a match for message " + message));
        Assertions.assertEquals((Object)message.getTimestamp(), (Object)resolver.resolveParameterValue((Message)message));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.ANNOTATION_TYPE})
    @Timestamp
    private static @interface CustomTimestamp {
    }
}

