/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.util.UUID;
import java.util.stream.IntStream;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.SequenceIdentifierCache;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SequenceIdentifierCacheTest {
    private final int CACHE_SIZE = 10;
    private final int SEGMENT_ID = 2;
    private SequenceIdentifierCache testSubject;
    private SequencedDeadLetterQueue<EventMessage<?>> mockSequencedDeadLetterQueue;

    SequenceIdentifierCacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockSequencedDeadLetterQueue = (SequencedDeadLetterQueue)Mockito.mock(SequencedDeadLetterQueue.class);
        ((SequencedDeadLetterQueue)Mockito.doReturn((Object)0L).when(this.mockSequencedDeadLetterQueue)).amountOfSequences();
        this.testSubject = new SequenceIdentifierCache(2, 10, this.mockSequencedDeadLetterQueue);
    }

    @Test
    void mightNotBePresentIfStartedWithEmptyQueue() {
        String sequenceIdentifier = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
    }

    @Test
    void itsNotPresentIfWeAlreadyKnowItsNotInTheQueue() {
        ((SequencedDeadLetterQueue)Mockito.doReturn((Object)10L).when(this.mockSequencedDeadLetterQueue)).amountOfSequences();
        this.testSubject = new SequenceIdentifierCache(2, 10, this.mockSequencedDeadLetterQueue);
        String sequenceIdentifier = UUID.randomUUID().toString();
        Assertions.assertTrue((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
        this.testSubject.markNotEnqueued((Object)sequenceIdentifier);
        Assertions.assertFalse((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
    }

    @Test
    void cacheIsCleanedOnceSizeBecomesLargerThenSetSize() {
        ((SequencedDeadLetterQueue)Mockito.doReturn((Object)10L).when(this.mockSequencedDeadLetterQueue)).amountOfSequences();
        this.testSubject = new SequenceIdentifierCache(2, 10, this.mockSequencedDeadLetterQueue);
        String sequenceIdentifier = UUID.randomUUID().toString();
        Assertions.assertTrue((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
        this.testSubject.markNotEnqueued((Object)sequenceIdentifier);
        Assertions.assertFalse((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
        IntStream.range(0, 10).forEach(i -> this.testSubject.markNotEnqueued((Object)UUID.randomUUID().toString()));
        Assertions.assertTrue((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
    }

    @Test
    void itMightBePresentOnceItsMarkedAsEnqueued() {
        String sequenceIdentifier = UUID.randomUUID().toString();
        Assertions.assertFalse((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
        this.testSubject.markEnqueued((Object)sequenceIdentifier);
        Assertions.assertTrue((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
    }

    @Test
    void onceMarkedAsNotEnqueuedWeKnowItsNotPresent() {
        String sequenceIdentifier = UUID.randomUUID().toString();
        this.testSubject.markEnqueued((Object)sequenceIdentifier);
        this.testSubject.markNotEnqueued((Object)sequenceIdentifier);
        Assertions.assertFalse((boolean)this.testSubject.mightBePresent((Object)sequenceIdentifier));
    }
}

