/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DeadLetterSchemaTest {
    public static final String TEST_COLUMN_NAME = "some-name";

    DeadLetterSchemaTest() {
    }

    @Test
    void buildWithDeadLetterTableReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().deadLetterTable(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.deadLetterTable());
    }

    @Test
    void buildWithNullDeadLetterTableThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.deadLetterTable(null));
    }

    @Test
    void buildWithEmptyDeadLetterTableThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.deadLetterTable(""));
    }

    @Test
    void buildWithDeadLetterIdentifierColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().deadLetterIdentifierColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.deadLetterIdentifierColumn());
    }

    @Test
    void buildWithNullDeadLetterIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.deadLetterIdentifierColumn(null));
    }

    @Test
    void buildWithEmptyDeadLetterIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.deadLetterIdentifierColumn(""));
    }

    @Test
    void buildWithProcessingGroupColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().processingGroupColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.processingGroupColumn());
    }

    @Test
    void buildWithNullProcessingGroupColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingGroupColumn(null));
    }

    @Test
    void buildWithEmptyProcessingGroupColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingGroupColumn(""));
    }

    @Test
    void buildWithSequenceIdentifierColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().sequenceIdentifierColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.sequenceIdentifierColumn());
    }

    @Test
    void buildWithNullSequenceIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceIdentifierColumn(null));
    }

    @Test
    void buildWithEmptySequenceIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceIdentifierColumn(""));
    }

    @Test
    void buildWithSequenceIndexColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().sequenceIndexColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.sequenceIndexColumn());
    }

    @Test
    void buildWithNullSequenceIndexColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceIndexColumn(null));
    }

    @Test
    void buildWithEmptySequenceIndexColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceIndexColumn(""));
    }

    @Test
    void buildWithMessageTypeColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().messageTypeColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.messageTypeColumn());
    }

    @Test
    void buildWithNullMessageTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.messageTypeColumn(null));
    }

    @Test
    void buildWithEmptyMessageTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.messageTypeColumn(""));
    }

    @Test
    void buildWithEventIdentifierColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().eventIdentifierColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.eventIdentifierColumn());
    }

    @Test
    void buildWithNullEventIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.eventIdentifierColumn(null));
    }

    @Test
    void buildWithEmptyEventIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.eventIdentifierColumn(""));
    }

    @Test
    void buildWithTimeStampColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().timestampColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.timestampColumn());
    }

    @Test
    void buildWithNullTimeStampColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.timestampColumn(null));
    }

    @Test
    void buildWithEmptyTimeStampColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.timestampColumn(""));
    }

    @Test
    void buildWithPayloadTypeColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().payloadTypeColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.payloadTypeColumn());
    }

    @Test
    void buildWithNullPayloadTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadTypeColumn(null));
    }

    @Test
    void buildWithEmptyPayloadTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadTypeColumn(""));
    }

    @Test
    void buildWithPayloadRevisionColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().payloadRevisionColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.payloadRevisionColumn());
    }

    @Test
    void buildWithNullPayloadRevisionColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadRevisionColumn(null));
    }

    @Test
    void buildWithEmptyPayloadRevisionColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadRevisionColumn(""));
    }

    @Test
    void buildWithPayloadColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().payloadColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.payloadColumn());
    }

    @Test
    void buildWithNullPayloadColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadColumn(null));
    }

    @Test
    void buildWithEmptyPayloadColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.payloadColumn(""));
    }

    @Test
    void buildWithMetaDataColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().metaDataColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.metaDataColumn());
    }

    @Test
    void buildWithNullMetaDataColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.metaDataColumn(null));
    }

    @Test
    void buildWithEmptyMetaDataColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.metaDataColumn(""));
    }

    @Test
    void buildWithAggregateTypeColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().aggregateTypeColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.aggregateTypeColumn());
    }

    @Test
    void buildWithNullAggregateTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.aggregateTypeColumn(null));
    }

    @Test
    void buildWithEmptyAggregateTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.aggregateTypeColumn(""));
    }

    @Test
    void buildWithAggregateIdentifierColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().aggregateIdentifierColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.aggregateIdentifierColumn());
    }

    @Test
    void buildWithNullAggregateIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.aggregateIdentifierColumn(null));
    }

    @Test
    void buildWithEmptyAggregateIdentifierColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.aggregateIdentifierColumn(""));
    }

    @Test
    void buildWithSequenceNumberColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().sequenceNumberColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.sequenceNumberColumn());
    }

    @Test
    void buildWithNullSequenceNumberColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceNumberColumn(null));
    }

    @Test
    void buildWithEmptySequenceNumberColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.sequenceNumberColumn(""));
    }

    @Test
    void buildWithTokenTypeColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().tokenTypeColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.tokenTypeColumn());
    }

    @Test
    void buildWithNullTokenTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.tokenTypeColumn(null));
    }

    @Test
    void buildWithEmptyTokenTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.tokenTypeColumn(""));
    }

    @Test
    void buildWithTokenColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().tokenColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.tokenColumn());
    }

    @Test
    void buildWithNullTokenColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.tokenColumn(null));
    }

    @Test
    void buildWithEmptyTokenColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.tokenColumn(""));
    }

    @Test
    void buildWithEnqueuedAtColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().enqueuedAtColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.enqueuedAtColumn());
    }

    @Test
    void buildWithNullEnqueuedAtColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.enqueuedAtColumn(null));
    }

    @Test
    void buildWithEmptyEnqueuedAtColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.enqueuedAtColumn(""));
    }

    @Test
    void buildWithLastTouchedColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().lastTouchedColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.lastTouchedColumn());
    }

    @Test
    void buildWithNullLastTouchedColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.lastTouchedColumn(null));
    }

    @Test
    void buildWithEmptyLastTouchedColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.lastTouchedColumn(""));
    }

    @Test
    void buildWithProcessingStartedColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().processingStartedColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.processingStartedColumn());
    }

    @Test
    void buildWithNullProcessingStartedColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingStartedColumn(null));
    }

    @Test
    void buildWithEmptyProcessingStartedColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingStartedColumn(""));
    }

    @Test
    void buildWithCauseTypeColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().causeTypeColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.causeTypeColumn());
    }

    @Test
    void buildWithNullCauseTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.causeTypeColumn(null));
    }

    @Test
    void buildWithEmptyCauseTypeColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.causeTypeColumn(""));
    }

    @Test
    void buildWithCauseMessageColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().causeMessageColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.causeMessageColumn());
    }

    @Test
    void buildWithNullCauseMessageColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.causeMessageColumn(null));
    }

    @Test
    void buildWithEmptyCauseMessageColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.causeMessageColumn(""));
    }

    @Test
    void buildWithDiagnosticsColumnReturnsConfiguredColumnName() {
        DeadLetterSchema result = DeadLetterSchema.builder().diagnosticsColumn(TEST_COLUMN_NAME).build();
        Assertions.assertEquals((Object)TEST_COLUMN_NAME, (Object)result.diagnosticsColumn());
    }

    @Test
    void buildWithNullDiagnosticsColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.diagnosticsColumn(null));
    }

    @Test
    void buildWithEmptyDiagnosticsColumnThrowsAxonConfigurationException() {
        DeadLetterSchema.Builder testBuilder = DeadLetterSchema.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.diagnosticsColumn(""));
    }
}

