/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.gateway;

import java.util.List;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.gateway.DefaultEventGateway;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DefaultEventGatewayTest {
    private DefaultEventGateway testSubject;
    private EventBus mockEventBus;
    private MessageDispatchInterceptor<EventMessage<?>> mockEventMessageTransformer;

    DefaultEventGatewayTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockEventBus = (EventBus)Mockito.mock(EventBus.class);
        this.mockEventMessageTransformer = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        Mockito.when((Object)this.mockEventMessageTransformer.handle((Message)Mockito.isA(EventMessage.class))).thenAnswer(invocation -> invocation.getArguments()[0]);
        this.testSubject = DefaultEventGateway.builder().eventBus(this.mockEventBus).dispatchInterceptors(new MessageDispatchInterceptor[]{this.mockEventMessageTransformer}).build();
    }

    @Test
    void publishSingleEvent() {
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EventMessage.class);
        this.testSubject.publish((Object)"Event1");
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).publish(new EventMessage[]{(EventMessage)eventCaptor.capture()});
        EventMessage result = (EventMessage)eventCaptor.getValue();
        Assertions.assertEquals((Object)"Event1", (Object)result.getPayload());
        ((MessageDispatchInterceptor)Mockito.verify(this.mockEventMessageTransformer)).handle((Message)eventCaptor.capture());
        EventMessage interceptedResult = (EventMessage)eventCaptor.getValue();
        Assertions.assertEquals((Object)"Event1", (Object)interceptedResult.getPayload());
    }

    @Test
    void publishMultipleEvents() {
        ArgumentCaptor eventsCaptor = ArgumentCaptor.forClass(List.class);
        ArgumentCaptor interceptedCaptor = ArgumentCaptor.forClass(EventMessage.class);
        this.testSubject.publish(new Object[]{"Event2", "Event3"});
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).publish((List)eventsCaptor.capture());
        List result = (List)eventsCaptor.getValue();
        Assertions.assertEquals((int)2, (int)result.size());
        Assertions.assertEquals((Object)"Event2", (Object)((EventMessage)result.get(0)).getPayload());
        Assertions.assertEquals((Object)"Event3", (Object)((EventMessage)result.get(1)).getPayload());
        ((MessageDispatchInterceptor)Mockito.verify(this.mockEventMessageTransformer, (VerificationMode)Mockito.times((int)2))).handle((Message)interceptedCaptor.capture());
        List interceptedResult = interceptedCaptor.getAllValues();
        Assertions.assertEquals((int)2, (int)interceptedResult.size());
        Assertions.assertEquals((Object)"Event2", (Object)((EventMessage)interceptedResult.get(0)).getPayload());
        Assertions.assertEquals((Object)"Event3", (Object)((EventMessage)interceptedResult.get(1)).getPayload());
    }
}

