/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import com.github.kagkarlsson.scheduler.Scheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventScheduler;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DbSchedulerEventSchedulerBuilderTest {
    private DbSchedulerEventScheduler.Builder builder;
    private final Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final EventBus eventBus = (EventBus)Mockito.mock(EventBus.class);

    DbSchedulerEventSchedulerBuilderTest() {
    }

    @BeforeEach
    void newBuilder() {
        this.builder = DbSchedulerEventScheduler.builder();
    }

    @Test
    void whenAllPropertiesAreSetCreatesManager() {
        DbSchedulerEventScheduler eventScheduler = this.builder.transactionManager(this.transactionManager).scheduler(this.scheduler).serializer(TestSerializer.JACKSON.getSerializer()).eventBus(this.eventBus).build();
        Assertions.assertNotNull((Object)eventScheduler);
    }

    @Test
    void validateNeedsAllPropertiesSet() {
        this.builder.scheduler(this.scheduler).transactionManager(this.transactionManager);
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.build());
    }

    @Test
    void whenSettingSchedulerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.scheduler(null));
    }

    @Test
    void whenSettingTransactionManagerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.transactionManager(null));
    }

    @Test
    void whenSettingSerializerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.serializer(null));
    }

    @Test
    void whenSettingEventBusWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.eventBus(null));
    }
}

