/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.lifecycle;

import java.util.concurrent.CompletableFuture;
import org.axonframework.lifecycle.ShutdownInProgressException;
import org.axonframework.lifecycle.ShutdownLatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ShutdownLatchTest {
    private final ShutdownLatch testSubject = new ShutdownLatch();

    ShutdownLatchTest() {
    }

    @Test
    void initializeCancelsEarlierShutdown() {
        this.testSubject.registerActivity();
        CompletableFuture latch = this.testSubject.initiateShutdown();
        this.testSubject.initialize();
        Assertions.assertTrue((boolean)latch.isCompletedExceptionally());
    }

    @Test
    void incrementThrowsShutdownInProgressExceptionIfShuttingDown() {
        this.testSubject.initiateShutdown();
        Assertions.assertThrows(ShutdownInProgressException.class, () -> ((ShutdownLatch)this.testSubject).registerActivity());
    }

    @Test
    void decrementCompletesWaitProcess() {
        ShutdownLatch.ActivityHandle activityHandle = this.testSubject.registerActivity();
        CompletableFuture latch = this.testSubject.initiateShutdown();
        Assertions.assertFalse((boolean)latch.isDone());
        activityHandle.end();
        Assertions.assertTrue((boolean)latch.isDone());
    }

    @Test
    void isShuttingDownIsFalseForNonAwaitedLatch() {
        Assertions.assertFalse((boolean)this.testSubject.isShuttingDown());
    }

    @Test
    void initiateShutdownOnEmptyLatchOpensImmediately() {
        CompletableFuture latch = this.testSubject.initiateShutdown();
        Assertions.assertTrue((boolean)latch.isDone());
    }

    @Test
    void isShuttingDownIsTrueForAwaitedLatch() {
        CompletableFuture latch = this.testSubject.initiateShutdown();
        Assertions.assertTrue((boolean)this.testSubject.isShuttingDown());
        Assertions.assertTrue((boolean)latch.isDone());
    }

    @Test
    void isShuttingDownThrowsSuppliedExceptionForAwaitedLatch() {
        CompletableFuture latch = this.testSubject.initiateShutdown();
        Assertions.assertThrows(SomeException.class, () -> this.testSubject.ifShuttingDown(() -> new SomeException()));
        Assertions.assertTrue((boolean)latch.isDone());
    }

    @Test
    void subsequentActivityHandleEndCallsDoNotInfluenceOtherHandles() {
        ShutdownLatch.ActivityHandle handleOne = this.testSubject.registerActivity();
        ShutdownLatch.ActivityHandle handleTwo = this.testSubject.registerActivity();
        handleOne.end();
        handleOne.end();
        CompletableFuture latch = this.testSubject.initiateShutdown();
        Assertions.assertFalse((boolean)latch.isDone());
        handleTwo.end();
        Assertions.assertTrue((boolean)latch.isDone());
    }

    private static class SomeException
    extends RuntimeException {
        private SomeException() {
        }
    }
}

