/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.RemoteExceptionDescription;
import org.axonframework.messaging.ResultMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericResultMessageTest {
    GenericResultMessageTest() {
    }

    @Test
    void exceptionalResult() {
        Throwable t = new Throwable("oops");
        ResultMessage resultMessage = GenericResultMessage.asResultMessage((Throwable)t);
        try {
            resultMessage.getPayload();
        }
        catch (IllegalPayloadAccessException ipae) {
            Assertions.assertEquals((Object)t, (Object)ipae.getCause());
        }
    }

    @Test
    void exceptionSerialization() {
        Throwable expected = new Throwable("oops");
        ResultMessage resultMessage = GenericResultMessage.asResultMessage((Throwable)expected);
        JacksonSerializer jacksonSerializer = JacksonSerializer.builder().build();
        SerializedObject serializedObject = resultMessage.serializeExceptionResult((Serializer)jacksonSerializer, String.class);
        RemoteExceptionDescription actual = (RemoteExceptionDescription)jacksonSerializer.deserialize(serializedObject);
        Assertions.assertEquals((Object)"java.lang.Throwable: oops", actual.getDescriptions().get(0));
    }
}

