/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import java.util.HashMap;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Headers;
import org.axonframework.serialization.FixedValueRevisionResolver;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.xml.CompactDriver;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class HeadersTests {
    private Serializer serializer;

    HeadersTests() {
    }

    @BeforeEach
    void setUp() {
        this.serializer = XStreamSerializer.builder().xStream(new XStream((HierarchicalStreamDriver)new CompactDriver())).revisionResolver((RevisionResolver)new FixedValueRevisionResolver("stub-revision")).build();
    }

    @Test
    void messageIdText() {
        MatcherAssert.assertThat((Object)"axon-message-id", (Matcher)CoreMatchers.is((Object)"axon-message-id"));
    }

    @Test
    void messageTypeText() {
        MatcherAssert.assertThat((Object)"axon-message-type", (Matcher)CoreMatchers.is((Object)"axon-message-type"));
    }

    @Test
    void messageRevisionText() {
        MatcherAssert.assertThat((Object)"axon-message-revision", (Matcher)CoreMatchers.is((Object)"axon-message-revision"));
    }

    @Test
    void messageTimeStampText() {
        MatcherAssert.assertThat((Object)"axon-message-timestamp", (Matcher)CoreMatchers.is((Object)"axon-message-timestamp"));
    }

    @Test
    void messageAggregateIdText() {
        MatcherAssert.assertThat((Object)"axon-message-aggregate-id", (Matcher)CoreMatchers.is((Object)"axon-message-aggregate-id"));
    }

    @Test
    void messageAggregateSeqText() {
        MatcherAssert.assertThat((Object)"axon-message-aggregate-seq", (Matcher)CoreMatchers.is((Object)"axon-message-aggregate-seq"));
    }

    @Test
    void messageAggregateTypeText() {
        MatcherAssert.assertThat((Object)"axon-message-aggregate-type", (Matcher)CoreMatchers.is((Object)"axon-message-aggregate-type"));
    }

    @Test
    void messageMetadataText() {
        MatcherAssert.assertThat((Object)"axon-metadata", (Matcher)CoreMatchers.is((Object)"axon-metadata"));
    }

    @Test
    void generatingDefaultMessagingHeaders() {
        final EventMessage message = GenericEventMessage.asEventMessage((Object)"foo");
        final SerializedObject serializedObject = message.serializePayload(this.serializer, byte[].class);
        HashMap<String, Object> expected = new HashMap<String, Object>(){
            {
                this.put("axon-message-id", message.getIdentifier());
                this.put("axon-message-type", serializedObject.getType().getName());
                this.put("axon-message-revision", serializedObject.getType().getRevision());
                this.put("axon-message-timestamp", message.getTimestamp());
            }
        };
        MatcherAssert.assertThat((Object)Headers.defaultHeaders((EventMessage)message, (SerializedObject)serializedObject), (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    void generatingDefaultMessagingHeaders_InvalidSerializedObject() {
        EventMessage message = GenericEventMessage.asEventMessage((Object)"foo");
        Assertions.assertThrows(IllegalArgumentException.class, () -> Headers.defaultHeaders((EventMessage)message, null));
    }

    @Test
    void generatingDomainMessagingHeaders() {
        final GenericDomainEventMessage<String> message = this.domainMessage();
        final SerializedObject serializedObject = message.serializePayload(this.serializer, byte[].class);
        HashMap<String, Object> expected = new HashMap<String, Object>(){
            {
                this.put("axon-message-id", message.getIdentifier());
                this.put("axon-message-type", serializedObject.getType().getName());
                this.put("axon-message-revision", serializedObject.getType().getRevision());
                this.put("axon-message-timestamp", message.getTimestamp());
                this.put("axon-message-aggregate-id", message.getAggregateIdentifier());
                this.put("axon-message-aggregate-seq", message.getSequenceNumber());
                this.put("axon-message-aggregate-type", message.getType());
            }
        };
        MatcherAssert.assertThat((Object)Headers.defaultHeaders(message, (SerializedObject)serializedObject), (Matcher)CoreMatchers.is((Object)expected));
    }

    private GenericDomainEventMessage<String> domainMessage() {
        return new GenericDomainEventMessage("Stub", "893612", 1L, (Object)"Payload");
    }
}

