/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.AllowReplay;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerAttributes;
import org.axonframework.messaging.annotation.HasHandlerAttributes;
import org.axonframework.messaging.annotation.MessageHandler;
import org.axonframework.messaging.interceptors.ExceptionHandler;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AnnotatedHandlerAttributesTest {
    private AnnotatedHandlerAttributes testSubject;

    AnnotatedHandlerAttributesTest() {
    }

    @BeforeEach
    void setUp() throws NoSuchMethodException {
        Method nonMessageHandlingMember = this.getClass().getMethod("annotatedNonMessageHandler", Object.class);
        this.testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)nonMessageHandlingMember);
    }

    @Test
    void constructHandlerAttributesForAnnotatedCommandHandler() throws NoSuchMethodException {
        Method messageHandlingMember = this.getClass().getMethod("annotatedCommandHandler", Object.class);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("MessageHandler.messageType", CommandMessage.class);
        expected.put("MessageHandler.payloadType", String.class);
        expected.put("CommandHandler.commandName", "my-command");
        expected.put("CommandHandler.routingKey", "my-routing-key");
        expected.put(CommandHandler.class.getSimpleName() + ".payloadType", String.class);
        AnnotatedHandlerAttributes testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)messageHandlingMember);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains("MessageHandler.messageType"));
        Assertions.assertEquals((Object)testSubject.get("MessageHandler.messageType"), CommandMessage.class);
        Assertions.assertEquals(expected, (Object)testSubject.getAll());
    }

    @Test
    void constructHandlerAttributesForAnnotatedAllowReplayAndEventHandler() throws NoSuchMethodException {
        Method messageHandlingMember = this.getClass().getMethod("annotatedAllowReplayAndEventHandler", Object.class);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("AllowReplay.allowReplay", true);
        expected.put("MessageHandler.messageType", EventMessage.class);
        expected.put("MessageHandler.payloadType", Boolean.class);
        expected.put(EventHandler.class.getSimpleName() + ".payloadType", Boolean.class);
        AnnotatedHandlerAttributes testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)messageHandlingMember);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains("AllowReplay.allowReplay"));
        Assertions.assertEquals((Object)true, (Object)testSubject.get("AllowReplay.allowReplay"));
        Assertions.assertEquals(expected, (Object)testSubject.getAll());
    }

    @Test
    void constructHandlerAttributesForAnnotatedExceptionHandler() throws NoSuchMethodException {
        Method messageHandlingMember = this.getClass().getMethod("annotatedExceptionHandler", Object.class);
        HashMap<String, Class<Object>> expected = new HashMap<String, Class<Object>>();
        expected.put("MessageHandler.messageType", Message.class);
        expected.put("MessageHandler.payloadType", Object.class);
        expected.put(MessageHandlerInterceptor.class.getSimpleName() + ".messageType", Message.class);
        expected.put(MessageHandlerInterceptor.class.getSimpleName() + ".payloadType", Object.class);
        expected.put("ResultHandler.resultType", Exception.class);
        expected.put("ExceptionHandler.resultType", Exception.class);
        expected.put(ExceptionHandler.class.getSimpleName() + ".messageType", Message.class);
        expected.put(ExceptionHandler.class.getSimpleName() + ".payloadType", Object.class);
        AnnotatedHandlerAttributes testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)messageHandlingMember);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains("ExceptionHandler.resultType"));
        Assertions.assertEquals((Object)testSubject.get("ExceptionHandler.resultType"), Exception.class);
        Assertions.assertEquals(expected, (Object)testSubject.getAll());
    }

    @Test
    void constructHandlerAttributesForAnnotatedCustomCommandHandler() throws NoSuchMethodException {
        Method messageHandlingMember = this.getClass().getMethod("annotatedCustomCommandHandler", Object.class);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("MessageHandler.messageType", CommandMessage.class);
        expected.put("MessageHandler.payloadType", Long.class);
        expected.put("CommandHandler.commandName", "custom-custom-name");
        expected.put("CommandHandler.routingKey", "custom-routing-key");
        expected.put(CommandHandler.class.getSimpleName() + ".payloadType", Long.class);
        expected.put(CustomCommandHandler.class.getSimpleName() + ".additionalAttribute", 42);
        expected.put(CustomCommandHandler.class.getSimpleName() + ".payloadType", Long.class);
        AnnotatedHandlerAttributes testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)messageHandlingMember);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains(CustomCommandHandler.class.getSimpleName() + ".additionalAttribute"));
        Assertions.assertEquals((int)42, (int)((Integer)testSubject.get(CustomCommandHandler.class.getSimpleName() + ".additionalAttribute")));
        Assertions.assertEquals(expected, (Object)testSubject.getAll());
    }

    @Test
    void constructHandlerAttributesForAnnotatedCustomCombinedHandlerWithAttributes() throws NoSuchMethodException {
        Method messageHandlingMember = this.getClass().getMethod("annotatedCustomCombinedHandlerWithAttributes", Object.class);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("MessageHandler.messageType", DeadlineMessage.class);
        expected.put("MessageHandler.payloadType", Float.class);
        expected.put(CustomCombinedHandlerWithAttributes.class.getSimpleName() + ".additionalAttribute", 42);
        AnnotatedHandlerAttributes testSubject = new AnnotatedHandlerAttributes((AnnotatedElement)messageHandlingMember);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains("MessageHandler.messageType"));
        Assertions.assertEquals((Object)testSubject.get("MessageHandler.messageType"), DeadlineMessage.class);
        Assertions.assertEquals(expected, (Object)testSubject.getAll());
    }

    @Test
    void constructHandlerAttributesForAnnotatedNonMessageHandler() {
        HashMap expected = new HashMap();
        Assertions.assertEquals(expected, (Object)this.testSubject.getAll());
    }

    @CommandHandler(commandName="my-command", routingKey="my-routing-key", payloadType=String.class)
    public void annotatedCommandHandler(Object command) {
    }

    @AllowReplay
    @EventHandler(payloadType=Boolean.class)
    public void annotatedAllowReplayAndEventHandler(Object event) {
    }

    @ExceptionHandler
    public void annotatedExceptionHandler(Object exception) {
    }

    @CustomCommandHandler(additionalAttribute=42, payloadType=Long.class)
    public void annotatedCustomCommandHandler(Object command) {
    }

    @CustomCombinedHandlerWithAttributes(additionalAttribute=42)
    public void annotatedCustomCombinedHandlerWithAttributes(Object command) {
    }

    @SomeOtherAnnotation(someAttribute=9001L)
    public void annotatedNonMessageHandler(Object regularParameter) {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.CONSTRUCTOR, ElementType.METHOD})
    protected static @interface SomeOtherAnnotation {
        public long someAttribute();
    }

    @HasHandlerAttributes
    @Retention(value=RetentionPolicy.RUNTIME)
    @MessageHandler(messageType=DeadlineMessage.class, payloadType=Float.class)
    protected static @interface CustomCombinedHandlerWithAttributes {
        public int additionalAttribute();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @CommandHandler(commandName="custom-custom-name", routingKey="custom-routing-key")
    protected static @interface CustomCommandHandler {
        public int additionalAttribute();

        public Class<?> payloadType();
    }
}

