/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.util.Optional;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMember;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AnnotatedMessageHandlingMemberTest {
    private AnnotatedMessageHandlingMember<AnnotatedHandler> testSubject;

    AnnotatedMessageHandlingMemberTest() {
    }

    @BeforeEach
    void setUp() {
        try {
            this.testSubject = new AnnotatedMessageHandlingMember((Executable)AnnotatedHandler.class.getMethod("handlingMethod", String.class), EventMessage.class, String.class, ClasspathParameterResolverFactory.forClass(AnnotatedHandler.class));
        }
        catch (NoSuchMethodException e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    void canHandleMessageType() {
        Assertions.assertTrue((boolean)this.testSubject.canHandleMessageType(EventMessage.class));
        Assertions.assertFalse((boolean)this.testSubject.canHandleMessageType(CommandMessage.class));
    }

    @Test
    void hasAnnotation() {
        Assertions.assertTrue((boolean)this.testSubject.hasAnnotation(EventHandler.class));
        Assertions.assertFalse((boolean)this.testSubject.hasAnnotation(CommandHandler.class));
    }

    @Test
    void attributeReturnsNonEmptyOptionalForMatchingAttributeKey() {
        Optional resultMessageType = this.testSubject.attribute("MessageHandler.messageType");
        Optional resultPayloadType = this.testSubject.attribute("MessageHandler.payloadType");
        Assertions.assertTrue((boolean)resultMessageType.isPresent());
        Assertions.assertEquals(EventMessage.class, resultMessageType.get());
        Assertions.assertTrue((boolean)resultPayloadType.isPresent());
        Assertions.assertEquals(Object.class, resultPayloadType.get());
    }

    private static class AnnotatedHandler {
        private AnnotatedHandler() {
        }

        @EventHandler
        public void handlingMethod(String event) {
        }
    }
}

