/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.List;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMember;
import org.axonframework.messaging.annotation.DefaultParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerComparator;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HandlerHierarchyTest {
    HandlerHierarchyTest() {
    }

    @Test
    void hierarchySort() throws NoSuchMethodException {
        MultiParameterResolverFactory multiParameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{new DefaultParameterResolverFactory()});
        AnnotatedMessageHandlingMember bHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", B.class), EventMessage.class, B.class, (ParameterResolverFactory)multiParameterResolverFactory);
        AnnotatedMessageHandlingMember iHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", I.class), EventMessage.class, I.class, (ParameterResolverFactory)multiParameterResolverFactory);
        AnnotatedMessageHandlingMember fHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", F.class), EventMessage.class, F.class, (ParameterResolverFactory)multiParameterResolverFactory);
        AnnotatedMessageHandlingMember aHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", A.class), EventMessage.class, A.class, (ParameterResolverFactory)multiParameterResolverFactory);
        AnnotatedMessageHandlingMember gHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", G.class), EventMessage.class, G.class, (ParameterResolverFactory)multiParameterResolverFactory);
        AnnotatedMessageHandlingMember eHandler = new AnnotatedMessageHandlingMember((Executable)MyEventHandler.class.getMethod("handle", E.class), EventMessage.class, E.class, (ParameterResolverFactory)multiParameterResolverFactory);
        List<MessageHandlingMember> handlers = Arrays.asList(bHandler, iHandler, fHandler, aHandler, gHandler, eHandler);
        handlers.sort(HandlerComparator.instance());
        Assertions.assertTrue((handlers.indexOf(gHandler) < handlers.indexOf(eHandler) ? 1 : 0) != 0);
    }

    private static class MyEventHandler {
        private MyEventHandler() {
        }

        @EventHandler
        public void handle(E event) {
        }

        @EventHandler
        public void handle(G event) {
        }

        @EventHandler
        public void handle(A event) {
        }

        @EventHandler
        public void handle(B event) {
        }

        @EventHandler
        public void handle(I event) {
        }

        @EventHandler
        public void handle(F event) {
        }
    }

    private static class B {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }

    private static abstract class G
    implements E {
        private G() {
        }
    }

    private static class I
    implements H {
        private I() {
        }
    }

    private static abstract class F
    implements D {
        private F() {
        }
    }

    private static interface E
    extends D {
    }

    private static interface H
    extends D {
    }

    private static interface D
    extends C {
    }

    private static interface C {
    }
}

