/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.DeadLetterParameterResolverFactory;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DeadLetterParameterResolverFactoryTest {
    private DeadLetterParameterResolverFactory testSubject;
    private Method nonDeadLetterParameterMethod;
    private Method deadLetterMethod;

    DeadLetterParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testSubject = new DeadLetterParameterResolverFactory();
        this.nonDeadLetterParameterMethod = this.getClass().getMethod("nonDeadLetterParameterMethod", Object.class);
        this.deadLetterMethod = this.getClass().getMethod("someDeadLetterMethod", DeadLetter.class);
    }

    @AfterEach
    void tearDown() {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    public void nonDeadLetterParameterMethod(Object event) {
    }

    public void someDeadLetterMethod(DeadLetter<?> deadLetter) {
    }

    @Test
    void ignoredForNonDeadLetterParameterMethod() {
        Assertions.assertNull((Object)this.testSubject.createInstance((Executable)this.nonDeadLetterParameterMethod, this.nonDeadLetterParameterMethod.getParameters(), 0));
    }

    @Test
    void createsResolverForDeadLetterParameterContainingMethod() {
        Assertions.assertNotNull((Object)this.testSubject.createInstance((Executable)this.deadLetterMethod, this.deadLetterMethod.getParameters(), 0));
    }

    @Test
    void resolverMatchesForAnyMessageType() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.deadLetterMethod, this.deadLetterMethod.getParameters(), 0);
        Assertions.assertTrue((boolean)resolver.matches((Message)GenericCommandMessage.asCommandMessage((Object)"some-command")));
        Assertions.assertTrue((boolean)resolver.matches((Message)GenericEventMessage.asEventMessage((Object)"some-command")));
        Assertions.assertTrue((boolean)resolver.matches((Message)new GenericQueryMessage((Object)"some-query", ResponseTypes.instanceOf(String.class))));
    }

    @Test
    void resolvesDeadLetterFromUnitOfWorkResources() {
        EventMessage testMessage = GenericEventMessage.asEventMessage((Object)"some-event");
        GenericDeadLetter expected = new GenericDeadLetter((Object)"sequenceId", (Message)testMessage, (Throwable)new RuntimeException("some-cause"));
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet((Message)testMessage);
        uow.resources().put(DeadLetter.class.getName(), expected);
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.deadLetterMethod, this.deadLetterMethod.getParameters(), 0);
        DeadLetter result = (DeadLetter)resolver.resolveParameterValue((Message)testMessage);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void resolvesNullWhenNoUnitOfWorkIsActive() {
        EventMessage testMessage = GenericEventMessage.asEventMessage((Object)"some-event");
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.deadLetterMethod, this.deadLetterMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver.resolveParameterValue((Message)testMessage));
    }

    @Test
    void resolvesNullWhenNoDeadLetterIsPresentInTheUnitOfWorkResources() {
        EventMessage testMessage = GenericEventMessage.asEventMessage((Object)"some-event");
        DefaultUnitOfWork.startAndGet((Message)testMessage);
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.deadLetterMethod, this.deadLetterMethod.getParameters(), 0);
        Assertions.assertNull((Object)resolver.resolveParameterValue((Message)testMessage));
    }
}

