/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.QueryBus;
import org.axonframework.queryhandling.QueryHandler;
import org.axonframework.queryhandling.QueryMessage;
import org.axonframework.queryhandling.QueryResponseMessage;
import org.axonframework.queryhandling.SimpleQueryBus;
import org.axonframework.queryhandling.annotation.AnnotationQueryHandlerAdapter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PrimitiveQueryHandlerResponseTypeTest {
    private final SimpleQueryBus queryBus = SimpleQueryBus.builder().build();
    private final PrimitiveQueryHandler queryHandler = new PrimitiveQueryHandler();
    private final AnnotationQueryHandlerAdapter<PrimitiveQueryHandler> annotationQueryHandlerAdapter = new AnnotationQueryHandlerAdapter((Object)this.queryHandler);

    PrimitiveQueryHandlerResponseTypeTest() {
    }

    @BeforeEach
    void setUp() {
        this.annotationQueryHandlerAdapter.subscribe((QueryBus)this.queryBus);
    }

    @Test
    void testInt() {
        this.test(0, Integer.class, Integer.TYPE);
    }

    @Test
    void testLong() {
        this.test(0L, Long.class, Long.TYPE);
    }

    @Test
    void testShort() {
        this.test((short)0, Short.class, Short.TYPE);
    }

    @Test
    void testFloat() {
        this.test(Float.valueOf(0.0f), Float.class, Float.TYPE);
    }

    @Test
    void testDouble() {
        this.test(0.0, Double.class, Double.TYPE);
    }

    @Test
    void testBoolean() {
        this.test(false, Boolean.class, Boolean.TYPE);
    }

    @Test
    void testByte() {
        this.test((byte)0, Byte.class, Byte.TYPE);
    }

    @Test
    void testChar() {
        this.test(Character.valueOf('0'), Character.class, Character.TYPE);
    }

    private <T> void test(T value, Class<T> boxed, Class<T> primitive) {
        GenericQueryMessage queryBoxed = new GenericQueryMessage(value, ResponseTypes.instanceOf(boxed));
        GenericQueryMessage queryPrimitive = new GenericQueryMessage(value, ResponseTypes.instanceOf(primitive));
        Object responseBoxed = ((QueryResponseMessage)this.queryBus.query((QueryMessage)queryBoxed).join()).getPayload();
        Object responsePrimitive = ((QueryResponseMessage)this.queryBus.query((QueryMessage)queryPrimitive).join()).getPayload();
        Assertions.assertEquals(value, (Object)responseBoxed);
        Assertions.assertEquals(value, (Object)responsePrimitive);
    }

    private static class PrimitiveQueryHandler {
        private PrimitiveQueryHandler() {
        }

        @QueryHandler
        public int handle(Integer query) {
            return query;
        }

        @QueryHandler
        public long handle(Long query) {
            return query;
        }

        @QueryHandler
        public short handle(Short query) {
            return query;
        }

        @QueryHandler
        public float handle(Float query) {
            return query.floatValue();
        }

        @QueryHandler
        public double handle(Double query) {
            return query;
        }

        @QueryHandler
        public boolean handle(Boolean query) {
            return query;
        }

        @QueryHandler
        public byte handle(Byte query) {
            return query;
        }

        @QueryHandler
        public char handle(Character query) {
            return query.charValue();
        }
    }
}

