/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling.registration;

import java.util.Collections;
import org.axonframework.queryhandling.QuerySubscription;
import org.axonframework.queryhandling.registration.DuplicateQueryHandlerSubscriptionException;
import org.axonframework.queryhandling.registration.FailingDuplicateQueryHandlerResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class FailingDuplicateQueryHandlerResolverTest {
    private final FailingDuplicateQueryHandlerResolver resolver = FailingDuplicateQueryHandlerResolver.instance();

    FailingDuplicateQueryHandlerResolverTest() {
    }

    @Test
    void throwsErrorOnDuplicateRegistration() {
        QuerySubscription existingHandler = this.mockSubscription();
        QuerySubscription addedHandler = this.mockSubscription();
        Assertions.assertThrows(DuplicateQueryHandlerSubscriptionException.class, () -> this.resolver.resolve("org.axon.MyQuery", MyQuery.class, Collections.singletonList(existingHandler), addedHandler));
    }

    private QuerySubscription mockSubscription() {
        QuerySubscription mock = (QuerySubscription)Mockito.mock(QuerySubscription.class);
        Mockito.when((Object)mock.getQueryHandler()).thenReturn(message -> null);
        Mockito.when((Object)mock.getResponseType()).thenReturn(MyResponse.class);
        return mock;
    }

    private final class MyResponse {
        private MyResponse() {
        }
    }

    private final class MyQuery {
        private MyQuery() {
        }
    }
}

