/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.SchemaStore;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;
import org.axonframework.serialization.avro.AvroSerializer;
import org.axonframework.serialization.avro.AvroSerializerStrategy;
import org.axonframework.serialization.avro.AvroUtil;
import org.axonframework.serialization.avro.DefaultSchemaIncompatibilityChecker;
import org.axonframework.serialization.avro.GenericRecordToByteArrayConverter;
import org.axonframework.serialization.avro.SchemaIncompatibilityChecker;
import org.axonframework.serialization.avro.SpecificRecordBaseSerializerStrategy;
import org.axonframework.serialization.avro.test.ComplexObject;
import org.axonframework.serialization.avro.test.ComplexObjectSchemas;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class AvroSerializerTest {
    private static final ComplexObject complexObject = ComplexObject.newBuilder().setValue1("foo").setValue2("bar").setValue3(42).build();
    private final RevisionResolver revisionResolver = payloadType -> null;
    private AvroSerializer testSubject;
    private Serializer serializer;
    private SchemaStore.Cache store;
    private static final GenericRecordToByteArrayConverter toByteArrayConverter = new GenericRecordToByteArrayConverter();

    @BeforeEach
    void setUp() {
        this.serializer = (Serializer)Mockito.spy((Object)JacksonSerializer.defaultSerializer());
        this.store = new SchemaStore.Cache();
        this.testSubject = AvroSerializer.builder().serializerDelegate(this.serializer).revisionResolver(this.revisionResolver).schemaStore((SchemaStore)this.store).build();
    }

    @Test
    void testBuilderMandatoryValues() {
        Assertions.assertEquals((Object)"SchemaStore is mandatory", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().build())).getMessage());
        Assertions.assertEquals((Object)"SerializerDelegate is mandatory", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().schemaStore((SchemaStore)new SchemaStore.Cache()).build())).getMessage());
        Assertions.assertEquals((Object)"At least one AvroSerializerStrategy must be provided.", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().serializerDelegate(this.serializer).schemaStore((SchemaStore)new SchemaStore.Cache()).includeDefaultAvroSerializationStrategies(false).build())).getMessage());
        Assertions.assertNotNull((Object)AvroSerializer.builder().revisionResolver(c -> "").serializerDelegate(this.serializer).schemaStore((SchemaStore)new SchemaStore.Cache()).includeDefaultAvroSerializationStrategies(false).addSerializerStrategy((AvroSerializerStrategy)new SpecificRecordBaseSerializerStrategy((SchemaStore)new SchemaStore.Cache(), c -> "", (SchemaIncompatibilityChecker)new DefaultSchemaIncompatibilityChecker())).build());
    }

    @Test
    void testBuilderSetterContracts() {
        Assertions.assertEquals((Object)"RevisionResolver may not be null", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().revisionResolver(null))).getMessage());
        Assertions.assertEquals((Object)"SchemaStore may not be null", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().schemaStore(null))).getMessage());
        Assertions.assertEquals((Object)"Serializer delegate may not be null", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().serializerDelegate(null))).getMessage());
        Assertions.assertEquals((Object)"AvroSerializerStrategy may not be null", (Object)((AxonConfigurationException)Assertions.assertThrows(AxonConfigurationException.class, () -> AvroSerializer.builder().addSerializerStrategy(null))).getMessage());
    }

    @Test
    void deliverCorrectConverter() {
        Converter converter = this.testSubject.getConverter();
        Assertions.assertInstanceOf(ChainingConverter.class, (Object)converter);
        Assertions.assertTrue((boolean)converter.canConvert(byte[].class, GenericRecord.class));
        Assertions.assertTrue((boolean)converter.canConvert(byte[].class, JsonNode.class));
    }

    @Test
    void deliverUnknownClassIfTypeIsNotOnClasspath() {
        Class clazz = this.testSubject.classForType((SerializedType)new SimpleSerializedType("org.acme.Foo", null));
        Assertions.assertEquals(UnknownSerializedType.class, (Object)clazz);
    }

    @Test
    void deliverEmptyType() {
        Assertions.assertEquals((Object)SimpleSerializedType.emptyType(), (Object)this.testSubject.typeForClass(null));
        Assertions.assertEquals((Object)SimpleSerializedType.emptyType(), (Object)this.testSubject.typeForClass(Void.class));
    }

    @Test
    void deliverNonEmptyType() {
        Assertions.assertEquals((Object)new SimpleSerializedType(String.class.getCanonicalName(), this.revisionResolver.revisionOf(String.class)), (Object)this.testSubject.typeForClass(String.class));
    }

    @Test
    void canSerialize() {
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(byte[].class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(GenericRecord.class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(String.class));
        Assertions.assertTrue((boolean)this.testSubject.canSerializeTo(InputStream.class));
        Assertions.assertFalse((boolean)this.testSubject.canSerializeTo(Integer.class));
    }

    @Test
    void serializeMetaDataByDelegate() {
        MetaData original = MetaData.from(Collections.singletonMap("test", "test"));
        SerializedObject serialized = this.testSubject.serialize((Object)original, byte[].class);
        MetaData actual = (MetaData)this.testSubject.deserialize(serialized);
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)"test", (Object)actual.get((Object)"test"));
        Assertions.assertEquals((int)1, (int)actual.size());
        ((Serializer)Mockito.verify((Object)this.serializer)).serialize((Object)original, byte[].class);
        ((Serializer)Mockito.verify((Object)this.serializer)).deserialize(serialized);
    }

    @Test
    void serializeNull() {
        SerializedObject serialized = this.testSubject.serialize(null, byte[].class);
        Assertions.assertEquals((Object)SerializedType.emptyType(), (Object)serialized.getType());
        Assertions.assertArrayEquals((byte[])"null".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])serialized.getData()));
        ((Serializer)Mockito.verify((Object)this.serializer)).serialize(null, byte[].class);
    }

    @Test
    void deserializeEmptyBytes() {
        Assertions.assertEquals(Void.class, (Object)this.testSubject.classForType(SerializedType.emptyType()));
        Assertions.assertNull((Object)this.testSubject.deserialize((SerializedObject)new SimpleSerializedObject((Object)new byte[0], byte[].class, SerializedType.emptyType())));
    }

    @Test
    void serializeAndDeserializeComplexObject() {
        this.store.addSchema(ComplexObject.getClassSchema());
        SerializedObject serialized = this.testSubject.serialize((Object)complexObject, byte[].class);
        Assertions.assertEquals((Object)serialized.getType().getName(), (Object)ComplexObject.class.getCanonicalName());
        ComplexObject deserialized = (ComplexObject)((Object)this.testSubject.deserialize(serialized));
        Assertions.assertEquals((Object)((Object)complexObject), (Object)((Object)deserialized));
    }

    @Test
    void serializeFromCompatibleObjectAndDeserialize() {
        this.store.addSchema(ComplexObject.getClassSchema());
        Schema schema2 = ComplexObjectSchemas.compatibleSchema;
        this.store.addSchema(schema2);
        GenericData.Record record = new GenericData.Record(schema2);
        record.put("value1", (Object)complexObject.getValue1());
        record.put("value2", (Object)complexObject.getValue2());
        record.put("value3", (Object)complexObject.getValue3());
        byte[] encodedBytes = toByteArrayConverter.convert((GenericRecord)record);
        SerializedObject<byte[]> serialized = AvroSerializerTest.createSerializedObject(encodedBytes, ComplexObject.class.getCanonicalName());
        Assertions.assertEquals((Object)serialized.getType().getName(), (Object)ComplexObject.class.getCanonicalName());
        ComplexObject deserialized = (ComplexObject)((Object)this.testSubject.deserialize(serialized));
        Assertions.assertEquals((Object)((Object)complexObject), (Object)((Object)deserialized));
    }

    @Test
    void deserializeFromGenericRecord() {
        this.store.addSchema(ComplexObject.getClassSchema());
        Schema schema2 = ComplexObjectSchemas.compatibleSchema;
        this.store.addSchema(schema2);
        GenericData.Record record = new GenericData.Record(schema2);
        record.put("value1", (Object)complexObject.getValue1());
        record.put("value2", (Object)complexObject.getValue2());
        record.put("value3", (Object)complexObject.getValue3());
        SerializedObject<GenericRecord> serialized = AvroSerializerTest.createSerializedObject((GenericRecord)record);
        ComplexObject deserialized = (ComplexObject)((Object)this.testSubject.deserialize(serialized));
        Assertions.assertEquals((Object)((Object)complexObject), (Object)((Object)deserialized));
    }

    @Test
    void serializeFromCompatibleWithAdditionalIgnoredFieldObjectAndDeserialize() {
        this.store.addSchema(ComplexObject.getClassSchema());
        Schema schema2 = ComplexObjectSchemas.compatibleSchemaWithAdditionalField;
        this.store.addSchema(schema2);
        GenericData.Record record = new GenericData.Record(schema2);
        record.put("value1", (Object)complexObject.getValue1());
        record.put("value2", (Object)complexObject.getValue2());
        record.put("value3", (Object)complexObject.getValue3());
        record.put("value4", (Object)"ignored value");
        byte[] encodedBytes = toByteArrayConverter.convert((GenericRecord)record);
        SerializedObject<byte[]> serialized = AvroSerializerTest.createSerializedObject(encodedBytes, ComplexObject.class.getCanonicalName());
        Assertions.assertEquals((Object)serialized.getType().getName(), (Object)ComplexObject.class.getCanonicalName());
        ComplexObject deserialized = (ComplexObject)((Object)this.testSubject.deserialize(serialized));
        Assertions.assertEquals((Object)((Object)complexObject), (Object)((Object)deserialized));
    }

    @Test
    void serializeFromCompatibleSchemaAndDeserializeUsingDefault() {
        this.store.addSchema(ComplexObject.getClassSchema());
        Schema schema2 = ComplexObjectSchemas.compatibleSchemaWithoutValue2;
        this.store.addSchema(schema2);
        GenericData.Record record = new GenericData.Record(schema2);
        record.put("value1", (Object)complexObject.getValue1());
        record.put("value3", (Object)complexObject.getValue3());
        byte[] encodedBytes = toByteArrayConverter.convert((GenericRecord)record);
        SerializedObject<byte[]> serialized = AvroSerializerTest.createSerializedObject(encodedBytes, ComplexObject.class.getCanonicalName());
        Assertions.assertEquals((Object)serialized.getType().getName(), (Object)ComplexObject.class.getCanonicalName());
        ComplexObject deserialized = (ComplexObject)((Object)this.testSubject.deserialize(serialized));
        Assertions.assertEquals((Object)"default value", (Object)deserialized.getValue2());
    }

    @ParameterizedTest
    @MethodSource(value={"serializerAndIncompatibleSerializedObject"})
    void failToDeserializeFromIncompatibleSchema(SerializedObject<byte[]> serialized, AvroSerializer serializer, DefaultSchemaIncompatibilityChecker incompatibilityChecker, String expectedMessage) {
        Assertions.assertEquals((Object)expectedMessage, (Object)((SerializationException)Assertions.assertThrows(SerializationException.class, () -> serializer.deserialize(serialized))).getMessage());
        Assertions.assertEquals((int)1, (int)incompatibilityChecker.getIncompatibilitiesCache().size());
    }

    static Stream<Arguments> serializerAndIncompatibleSerializedObject() {
        Schema writerSchema = ComplexObjectSchemas.incompatibleSchema;
        SchemaCompatibility.Incompatibility incompatibility = (SchemaCompatibility.Incompatibility)SchemaCompatibility.checkReaderWriterCompatibility((Schema)ComplexObject.getClassSchema(), (Schema)writerSchema).getResult().getIncompatibilities().get(0);
        SchemaStore.Cache schemaStore = new SchemaStore.Cache();
        schemaStore.addSchema(ComplexObject.getClassSchema());
        schemaStore.addSchema(writerSchema);
        DefaultSchemaIncompatibilityChecker incompatibilityChecker = new DefaultSchemaIncompatibilityChecker();
        GenericData.Record record = new GenericData.Record(writerSchema);
        record.put("value2", (Object)complexObject.getValue1());
        record.put("value3", (Object)complexObject.getValue3());
        byte[] encodedBytes = toByteArrayConverter.convert((GenericRecord)record);
        SerializedObject<byte[]> serialized = AvroSerializerTest.createSerializedObject(encodedBytes, ComplexObject.class.getCanonicalName());
        Assertions.assertEquals((Object)serialized.getType().getName(), (Object)ComplexObject.class.getCanonicalName());
        return Stream.of(Arguments.of((Object[])new Object[]{serialized, AvroSerializer.builder().serializerDelegate((Serializer)JacksonSerializer.defaultSerializer()).revisionResolver(c -> null).performSchemaCompatibilityCheck(true).includeSchemasInStackTraces(false).schemaStore((SchemaStore)schemaStore).schemaIncompatibilityChecker((SchemaIncompatibilityChecker)incompatibilityChecker).build(), incompatibilityChecker, AvroUtil.createExceptionFailedToDeserialize(ComplexObject.class, (Schema)ComplexObject.getClassSchema(), (Schema)writerSchema, (String)("[" + AvroUtil.incompatibilityPrinter((SchemaCompatibility.Incompatibility)incompatibility) + "]"), (boolean)false).getMessage()}), Arguments.of((Object[])new Object[]{serialized, AvroSerializer.builder().serializerDelegate((Serializer)JacksonSerializer.defaultSerializer()).revisionResolver(c -> null).schemaStore((SchemaStore)schemaStore).performSchemaCompatibilityCheck(true).includeSchemasInStackTraces(true).build(), incompatibilityChecker, AvroUtil.createExceptionFailedToDeserialize(ComplexObject.class, (Schema)ComplexObject.getClassSchema(), (Schema)writerSchema, (String)("[" + AvroUtil.incompatibilityPrinter((SchemaCompatibility.Incompatibility)incompatibility) + "]"), (boolean)true).getMessage()}), Arguments.of((Object[])new Object[]{serialized, AvroSerializer.builder().serializerDelegate((Serializer)JacksonSerializer.defaultSerializer()).revisionResolver(c -> null).schemaStore((SchemaStore)schemaStore).performSchemaCompatibilityCheck(false).includeSchemasInStackTraces(false).build(), incompatibilityChecker, AvroUtil.createExceptionFailedToDeserialize(ComplexObject.class, (Schema)ComplexObject.getClassSchema(), (Schema)writerSchema, (Exception)null, (boolean)false).getMessage()}), Arguments.of((Object[])new Object[]{serialized, AvroSerializer.builder().serializerDelegate((Serializer)JacksonSerializer.defaultSerializer()).revisionResolver(c -> null).schemaStore((SchemaStore)schemaStore).performSchemaCompatibilityCheck(false).includeSchemasInStackTraces(true).build(), incompatibilityChecker, AvroUtil.createExceptionFailedToDeserialize(ComplexObject.class, (Schema)ComplexObject.getClassSchema(), (Schema)writerSchema, (Exception)null, (boolean)true).getMessage()}));
    }

    @Test
    void failToDeserializeIfClassIsNotAvailable() {
        Schema writerSchema = ComplexObjectSchemas.incompatibleSchema;
        this.store.addSchema(writerSchema);
        GenericData.Record record = new GenericData.Record(writerSchema);
        record.put("value2", (Object)complexObject.getValue1());
        record.put("value3", (Object)complexObject.getValue3());
        SimpleSerializedObject object = new SimpleSerializedObject((Object)record, GenericRecord.class, (SerializedType)new SimpleSerializedType("org.acme.Foo", null));
        Object deserialized = this.testSubject.deserialize((SerializedObject)object);
        Assertions.assertEquals(UnknownSerializedType.class, deserialized.getClass());
    }

    private static SerializedObject<byte[]> createSerializedObject(byte[] payload, String objectType) {
        return new SimpleSerializedObject((Object)payload, byte[].class, (SerializedType)new SimpleSerializedType(objectType, null));
    }

    private static SerializedObject<GenericRecord> createSerializedObject(GenericRecord record) {
        return new SimpleSerializedObject((Object)record, GenericRecord.class, (SerializedType)new SimpleSerializedType(record.getSchema().getFullName(), null));
    }
}

