/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.avro;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.message.SchemaStore;
import org.axonframework.eventhandling.AbstractSequencedDomainEventEntry;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.avro.AvroSerializer;
import org.axonframework.serialization.avro.GenericRecordToByteArrayConverter;
import org.axonframework.serialization.avro.test.ComplexObject;
import org.axonframework.serialization.avro.test.ComplexObjectSchemas;
import org.axonframework.serialization.json.JacksonSerializer;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.SingleEventUpcaster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AvroUpcasterTest {
    private final SchemaStore.Cache schemaStore = new SchemaStore.Cache();
    private final AvroSerializer serializer = AvroSerializer.builder().serializerDelegate((Serializer)JacksonSerializer.defaultSerializer()).revisionResolver((RevisionResolver)new AnnotationRevisionResolver()).schemaStore((SchemaStore)this.schemaStore).includeDefaultAvroSerializationStrategies(true).includeSchemasInStackTraces(true).build();

    @Test
    void modifyPropertyOfComplexObjectInUpcaster() {
        this.schemaStore.addSchema(ComplexObject.getClassSchema());
        MetaData metaData = MetaData.with((String)"key", (Object)"value");
        ComplexObject payload = ComplexObject.newBuilder().setValue1("foo").setValue2("bar").setValue3(42).build();
        GenericDomainEventMessage msg = new GenericDomainEventMessage(ComplexObject.class.getCanonicalName(), "aggregateId", 0L, (Object)payload, (Map)metaData);
        ByteArrayDomainEventEntry eventData = new ByteArrayDomainEventEntry((DomainEventMessage<?>)msg, (Serializer)this.serializer);
        SetValue2OnComplexObjectUpcaster setValue2OnComplexObjectUpcaster = new SetValue2OnComplexObjectUpcaster("helloWorld");
        List collect = setValue2OnComplexObjectUpcaster.upcast(Stream.of(new InitialEventRepresentation((EventData)eventData, (Serializer)this.serializer))).collect(Collectors.toList());
        Assertions.assertFalse((boolean)collect.isEmpty());
        IntermediateEventRepresentation r = (IntermediateEventRepresentation)collect.get(0);
        ComplexObject upcasted = (ComplexObject)((Object)this.serializer.deserialize(r.getData()));
        Assertions.assertEquals((Object)"helloWorld", (Object)upcasted.getValue2());
    }

    @Test
    void upcastIncompatibleSchema() {
        this.schemaStore.addSchema(ComplexObject.getClassSchema());
        this.schemaStore.addSchema(ComplexObjectSchemas.incompatibleSchema);
        GenericData.Record record = new GenericData.Record(ComplexObjectSchemas.incompatibleSchema);
        record.put("value2", (Object)"oldValue2");
        record.put("value3", (Object)42);
        SerializedObject<byte[]> oldPayload = AvroUpcasterTest.createSingleObjectEncodedSerializedObject((GenericRecord)record, "1");
        Assertions.assertThrows(SerializationException.class, () -> this.serializer.deserialize(oldPayload));
        SingleEventUpcaster setMissingValue1Upcaster = new SingleEventUpcaster(){

            protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
                return true;
            }

            protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
                return intermediateRepresentation.upcastPayload(intermediateRepresentation.getType(), GenericRecord.class, oldRecord -> {
                    GenericData.Record newRecord = new GenericData.Record(ComplexObject.getClassSchema());
                    newRecord.put("value1", (Object)"foo");
                    newRecord.put("value2", oldRecord.get("value2"));
                    newRecord.put("value3", oldRecord.get("value3"));
                    return newRecord;
                });
            }
        };
        SerializedObject dataAfterUpcast = ((IntermediateEventRepresentation)setMissingValue1Upcaster.upcast(Stream.of(new InitialEventRepresentation(AvroUpcasterTest.eventData(oldPayload, (SerializedObject<byte[]>)this.serializer.serialize((Object)MetaData.with((String)"key", (Object)"value"), byte[].class)), (Serializer)this.serializer))).collect(Collectors.toList()).get(0)).getData();
        ComplexObject upcasted = (ComplexObject)((Object)this.serializer.deserialize(dataAfterUpcast));
        Assertions.assertEquals((Object)"foo", (Object)upcasted.getValue1());
    }

    private static EventData<byte[]> eventData(final SerializedObject<byte[]> payload, final SerializedObject<byte[]> metaData) {
        return new EventData<byte[]>(){

            public String getEventIdentifier() {
                return UUID.randomUUID().toString();
            }

            public Instant getTimestamp() {
                return Instant.now();
            }

            public SerializedObject<byte[]> getMetaData() {
                return metaData;
            }

            public SerializedObject<byte[]> getPayload() {
                return payload;
            }
        };
    }

    private static SerializedObject<byte[]> createSingleObjectEncodedSerializedObject(GenericRecord record, String revision) {
        return new SimpleSerializedObject((Object)new GenericRecordToByteArrayConverter().convert(record), byte[].class, (SerializedType)new SimpleSerializedType(record.getSchema().getFullName(), revision));
    }

    private static class ByteArrayDomainEventEntry
    extends AbstractSequencedDomainEventEntry<byte[]> {
        public ByteArrayDomainEventEntry(DomainEventMessage<?> event, Serializer serializer) {
            super(event, serializer, byte[].class);
        }
    }

    private static class SetValue2OnComplexObjectUpcaster
    extends SingleEventUpcaster {
        private final String newValue2;

        public SetValue2OnComplexObjectUpcaster(String newValue2) {
            this.newValue2 = newValue2;
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return true;
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return intermediateRepresentation.upcastPayload(intermediateRepresentation.getType(), GenericRecord.class, it -> {
                it.put("value2", (Object)this.newValue2);
                return it;
            });
        }
    }
}

