/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.upcasting.event;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;
import org.axonframework.serialization.upcasting.event.SingleEventUpcaster;
import org.axonframework.utils.StubDomainEvent;
import org.axonframework.utils.TestDomainEventEntry;
import org.dom4j.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SingleEventUpcasterTest {
    private final Serializer serializer = TestSerializer.XSTREAM.getSerializer();

    SingleEventUpcasterTest() {
    }

    @Test
    void upcastsKnownType() {
        String newValue = "newNameValue";
        MetaData metaData = MetaData.with((String)"key", (Object)"value");
        TestDomainEventEntry eventData = new TestDomainEventEntry((DomainEventMessage<?>)new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName"), (Map)metaData), this.serializer);
        StubEventUpcaster upcaster = new StubEventUpcaster(newValue);
        List result = upcaster.upcast(Stream.of(new InitialEventRepresentation((EventData)eventData, this.serializer))).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation firstEvent = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertEquals((Object)"1", (Object)firstEvent.getType().getRevision());
        StubDomainEvent upcastedEvent = (StubDomainEvent)this.serializer.deserialize(firstEvent.getData());
        Assertions.assertEquals((Object)newValue, (Object)upcastedEvent.getName());
        Assertions.assertEquals((Object)eventData.getEventIdentifier(), (Object)firstEvent.getMessageIdentifier());
        Assertions.assertEquals((Object)eventData.getTimestamp(), (Object)firstEvent.getTimestamp());
        Assertions.assertEquals((Object)metaData, (Object)firstEvent.getMetaData().getObject());
    }

    @Test
    void upcastingDomainEventData() {
        String aggregateType = "test";
        String aggregateId = "aggregateId";
        GlobalSequenceTrackingToken trackingToken = new GlobalSequenceTrackingToken(10L);
        long sequenceNumber = 100L;
        StubDomainEvent payload = new StubDomainEvent("oldName");
        SerializedObject serializedPayload = this.serializer.serialize((Object)payload, String.class);
        TrackedDomainEventData eventData = new TrackedDomainEventData((TrackingToken)trackingToken, (DomainEventData)new GenericDomainEventEntry(aggregateType, aggregateId, sequenceNumber, "eventId", (Object)Instant.now(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), (Object)serializedPayload, (Object)this.serializer.serialize((Object)MetaData.emptyInstance(), String.class)));
        StubEventUpcaster upcaster = new StubEventUpcaster("whatever");
        InitialEventRepresentation input = new InitialEventRepresentation((EventData)eventData, this.serializer);
        List result = upcaster.upcast(Stream.of(input)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation firstEvent = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertEquals((Object)aggregateType, firstEvent.getAggregateType().get());
        Assertions.assertEquals((Object)aggregateId, firstEvent.getAggregateIdentifier().get());
        Assertions.assertEquals((Object)trackingToken, firstEvent.getTrackingToken().get());
        Assertions.assertEquals((Long)sequenceNumber, (Long)((Long)firstEvent.getSequenceNumber().get()));
    }

    @Test
    void ignoresUnknownType() {
        TestDomainEventEntry eventData = new TestDomainEventEntry((DomainEventMessage<?>)new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)"someString"), this.serializer);
        StubEventUpcaster upcaster = new StubEventUpcaster("whatever");
        IntermediateEventRepresentation input = (IntermediateEventRepresentation)Mockito.spy((Object)new InitialEventRepresentation((EventData)eventData, this.serializer));
        List result = upcaster.upcast(Stream.of(input)).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)result.size());
        IntermediateEventRepresentation output = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertSame((Object)input, (Object)output);
        ((IntermediateEventRepresentation)Mockito.verify((Object)input, (VerificationMode)Mockito.never())).getData();
    }

    @Test
    void ignoresWrongVersion() {
        TestDomainEventEntry eventData = new TestDomainEventEntry((DomainEventMessage<?>)new GenericDomainEventMessage("test", "aggregateId", 0L, (Object)new StubDomainEvent("oldName")), this.serializer);
        StubEventUpcaster upcaster = new StubEventUpcaster("whatever");
        InitialEventRepresentation input = new InitialEventRepresentation((EventData)eventData, this.serializer);
        List result = upcaster.upcast(Stream.of(input)).collect(Collectors.toList());
        input = (IntermediateEventRepresentation)Mockito.spy(result.get(0));
        Assertions.assertEquals((Object)"1", (Object)input.getType().getRevision());
        result = upcaster.upcast(Stream.of(input)).collect(Collectors.toList());
        Assertions.assertFalse((boolean)result.isEmpty());
        IntermediateEventRepresentation output = (IntermediateEventRepresentation)result.get(0);
        Assertions.assertSame((Object)input, (Object)output);
        ((IntermediateEventRepresentation)Mockito.verify((Object)input, (VerificationMode)Mockito.never())).getData();
    }

    private static class StubEventUpcaster
    extends SingleEventUpcaster {
        private final SerializedType targetType = new SimpleSerializedType(StubDomainEvent.class.getName(), null);
        private final Class<Document> expectedType = Document.class;
        private final String newNameValue;

        private StubEventUpcaster(String newNameValue) {
            this.newNameValue = newNameValue;
        }

        protected boolean canUpcast(IntermediateEventRepresentation intermediateRepresentation) {
            return intermediateRepresentation.getType().equals(this.targetType);
        }

        protected IntermediateEventRepresentation doUpcast(IntermediateEventRepresentation ir) {
            return ir.upcastPayload((SerializedType)new SimpleSerializedType(this.targetType.getName(), "1"), this.expectedType, doc -> {
                doc.getRootElement().element("name").setText(this.newNameValue);
                return doc;
            });
        }
    }
}

