/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DefaultCommandBusSpanFactory;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.Message;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;

class DefaultCommandBusSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultCommandBusSpanFactory.Builder, DefaultCommandBusSpanFactory> {
    DefaultCommandBusSpanFactoryTest() {
    }

    @Test
    void createLocalDispatchCommand() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.test(spanFactory -> spanFactory.createDispatchCommandSpan(command, false), this.expectedSpan("CommandBus.dispatchCommand", TestSpanFactory.TestSpanType.INTERNAL).withMessage((Message<?>)command));
    }

    @Test
    void createDistributedDispatchCommand() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.test(spanFactory -> spanFactory.createDispatchCommandSpan(command, true), this.expectedSpan("CommandBus.dispatchDistributedCommand", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)command));
    }

    @Test
    void createLocalHandleCommand() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.test(spanFactory -> spanFactory.createHandleCommandSpan(command, false), this.expectedSpan("CommandBus.handleCommand", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)command));
    }

    @Test
    void createDistributedHandleCommandDefault() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.test(spanFactory -> spanFactory.createHandleCommandSpan(command, true), this.expectedSpan("CommandBus.handleDistributedCommand", TestSpanFactory.TestSpanType.HANDLER_CHILD).withMessage((Message<?>)command));
    }

    @Test
    void createDistributedHandleCommandDistributedNotSameTrace() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.test(builder -> builder.distributedInSameTrace(false), spanFactory -> spanFactory.createHandleCommandSpan(command, true), this.expectedSpan("CommandBus.handleDistributedCommand", TestSpanFactory.TestSpanType.HANDLER_LINK).withMessage((Message<?>)command));
    }

    @Test
    void propagateContext() {
        CommandMessage command = GenericCommandMessage.asCommandMessage((Object)"MyCommand");
        this.testContextPropagation(command, DefaultCommandBusSpanFactory::propagateContext);
    }

    @Override
    protected DefaultCommandBusSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultCommandBusSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DefaultCommandBusSpanFactory createFactoryBasedOnBuilder(DefaultCommandBusSpanFactory.Builder builder) {
        return builder.build();
    }
}

