/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolution;
import org.axonframework.commandhandling.DuplicateCommandHandlerResolver;
import org.axonframework.commandhandling.DuplicateCommandHandlerSubscriptionException;
import org.axonframework.messaging.MessageHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DuplicateCommandHandlerResolutionTest {
    private MessageHandler<? super CommandMessage<?>> initialHandler;
    private MessageHandler<? super CommandMessage<?>> duplicateHandler;

    DuplicateCommandHandlerResolutionTest() {
    }

    @BeforeEach
    void setUp() {
        this.initialHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        ((MessageHandler)Mockito.doReturn(Handler1.class).when(this.initialHandler)).getTargetType();
        this.duplicateHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        ((MessageHandler)Mockito.doReturn(Handler2.class).when(this.duplicateHandler)).getTargetType();
    }

    @Test
    void logAndOverride() {
        DuplicateCommandHandlerResolver testSubject = DuplicateCommandHandlerResolution.logAndOverride();
        MessageHandler result = testSubject.resolve("test", this.initialHandler, this.duplicateHandler);
        Assertions.assertEquals(this.duplicateHandler, (Object)result);
    }

    @Test
    void silentlyOverride() {
        DuplicateCommandHandlerResolver testSubject = DuplicateCommandHandlerResolution.silentOverride();
        MessageHandler result = testSubject.resolve("test", this.initialHandler, this.duplicateHandler);
        Assertions.assertEquals(this.duplicateHandler, (Object)result);
    }

    @Test
    void duplicateHandlersRejected() {
        DuplicateCommandHandlerResolver testSubject = DuplicateCommandHandlerResolution.rejectDuplicates();
        try {
            testSubject.resolve("testCommand", this.initialHandler, this.duplicateHandler);
            Assertions.fail((String)"Expected DuplicateCommandHandlerSubscriptionException");
        }
        catch (DuplicateCommandHandlerSubscriptionException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("[testCommand]"));
            Assertions.assertTrue((boolean)e.getMessage().contains("Handler2]"));
            Assertions.assertTrue((boolean)e.getMessage().contains("Handler1]"));
        }
    }

    public static class Handler2 {
    }

    public static class Handler1 {
    }
}

