/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.distributed.CommandCallbackRepository;
import org.axonframework.commandhandling.distributed.CommandCallbackWrapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandCallbackRepositoryTest {
    private int successCounter;
    private int failCounter;

    CommandCallbackRepositoryTest() {
    }

    @BeforeEach
    void reset() {
        this.successCounter = 0;
        this.failCounter = 0;
    }

    @Test
    void callback() {
        CommandCallbackRepository repository = new CommandCallbackRepository();
        CommandCallbackWrapper<Object, Object, Object> commandCallbackWrapper = this.createWrapper("A");
        repository.store("A", commandCallbackWrapper);
        Assertions.assertEquals((int)1, (int)repository.callbacks().size());
        CommandCallbackWrapper fetchedCallback = repository.fetchAndRemove("A");
        Assertions.assertEquals(commandCallbackWrapper, (Object)fetchedCallback);
        Assertions.assertEquals((int)0, (int)repository.callbacks().size());
        fetchedCallback.reportResult(GenericCommandResultMessage.asCommandResultMessage((Object)new Object()));
        Assertions.assertEquals((int)1, (int)this.successCounter);
    }

    @Test
    void overwriteCallback() {
        CommandCallbackRepository repository = new CommandCallbackRepository();
        CommandCallbackWrapper<Object, Object, Object> commandCallbackWrapper = this.createWrapper("A");
        repository.store("A", commandCallbackWrapper);
        Assertions.assertEquals((int)1, (int)repository.callbacks().size());
        CommandCallbackWrapper<Object, Object, Object> commandCallbackWrapper2 = this.createWrapper("A");
        repository.store("A", commandCallbackWrapper2);
        Assertions.assertEquals((int)1, (int)this.failCounter);
        Assertions.assertTrue((boolean)repository.callbacks().containsValue(commandCallbackWrapper2));
        Assertions.assertFalse((boolean)repository.callbacks().containsValue(commandCallbackWrapper));
    }

    @Test
    void cancelCallbacks() {
        CommandCallbackRepository repository = new CommandCallbackRepository();
        repository.store("A", this.createWrapper("A"));
        repository.store("B", this.createWrapper("A"));
        repository.store("C", this.createWrapper("A"));
        repository.store("D", this.createWrapper("B"));
        Assertions.assertEquals((int)4, (int)repository.callbacks().size());
        repository.cancelCallbacks((Object)"C");
        Assertions.assertEquals((int)4, (int)repository.callbacks().size());
        repository.cancelCallbacks((Object)"A");
        Assertions.assertEquals((int)1, (int)repository.callbacks().size());
        Assertions.assertEquals((int)3, (int)this.failCounter);
        Assertions.assertEquals((int)0, (int)this.successCounter);
    }

    private CommandCallbackWrapper<Object, Object, Object> createWrapper(Object sessionId) {
        return new CommandCallbackWrapper(sessionId, (CommandMessage)new GenericCommandMessage(new Object()), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                ++this.failCounter;
            } else {
                ++this.successCounter;
            }
        });
    }
}

