/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.ConsistentHash;
import org.axonframework.commandhandling.distributed.Member;
import org.axonframework.commandhandling.distributed.SimpleMember;
import org.axonframework.commandhandling.distributed.commandfilter.AcceptAll;
import org.axonframework.commandhandling.distributed.commandfilter.CommandNameFilter;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConsistentHashTest {
    private ConsistentHash testSubject;
    private Member member1;
    private Member member2;

    ConsistentHashTest() {
    }

    @BeforeEach
    void setUp() {
        this.member1 = new SimpleMember("member1", (Object)"", false, null);
        this.member2 = new SimpleMember("member2", (Object)"", false, null);
        SimpleMember member3 = new SimpleMember("member3", (Object)"", false, null);
        this.testSubject = new ConsistentHash().with(this.member1, 2, (CommandMessageFilter)new CommandNameFilter("name1")).with(this.member2, 2, (CommandMessageFilter)new CommandNameFilter("name1")).with((Member)member3, 2, (CommandMessageFilter)new CommandNameFilter("name3"));
    }

    @Test
    void testToString() {
        Assertions.assertEquals((Object)"ConsistentHash [member1(2),member2(2),member3(2)]", (Object)this.testSubject.toString());
    }

    @Test
    void consistentHashChangesVersionWhenModified() {
        Assertions.assertEquals((int)3, (int)this.testSubject.version());
        Assertions.assertEquals((int)4, (int)this.testSubject.without(this.member1).version());
        Assertions.assertEquals((int)4, (int)this.testSubject.without(this.member1).without(this.member1).version());
    }

    @Test
    void messageRoutedToFirstEligibleMember() {
        Optional actual = this.testSubject.getMember("routingKey", (CommandMessage)new GenericCommandMessage((Message)new GenericMessage((Object)"test"), "name1"));
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertEquals((Object)"member1", (Object)((Member)actual.get()).name());
    }

    @Test
    void messageRoutedToNextEligibleMemberIfFirstChoiceIsRemoved() {
        Optional actual = this.testSubject.without(this.member1).getMember("routingKey", (CommandMessage)new GenericCommandMessage((Message)new GenericMessage((Object)"test"), "name1"));
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertEquals((Object)"member2", (Object)((Member)actual.get()).name());
    }

    @Test
    void nonEligibleMembersIgnored() {
        Optional actual = this.testSubject.getMember("routingKey", (CommandMessage)new GenericCommandMessage((Message)new GenericMessage((Object)"test"), "name3"));
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertEquals((Object)"member3", (Object)((Member)actual.get()).name());
    }

    @Test
    void noMemberReturnedWhenNoEligibleMembers() {
        Optional actual = this.testSubject.getMember("routingKey", (CommandMessage)new GenericCommandMessage((Message)new GenericMessage((Object)"test"), "unknown"));
        Assertions.assertFalse((boolean)actual.isPresent());
    }

    @Test
    void eligibleMembersCorrectlyOrdered() {
        Collection actual = this.testSubject.getEligibleMembers("someOtherKey");
        Assertions.assertEquals(Arrays.asList("member2", "member1", "member3"), actual.stream().map(ConsistentHash.ConsistentHashMember::name).collect(Collectors.toList()));
    }

    @Test
    void conflictingHashesDoNotImpactMembership() {
        ConsistentHash consistentHash = new ConsistentHash(s -> "fixed").with(this.member1, 1, (CommandMessageFilter)AcceptAll.INSTANCE);
        ConsistentHash consistentHashModified = consistentHash.with(this.member2, 1, (CommandMessageFilter)AcceptAll.INSTANCE).without(this.member2);
        Assertions.assertEquals((Object)this.member1.name(), (Object)((Member)consistentHash.getMembers().iterator().next()).name());
        Assertions.assertEquals((Object)consistentHash.getMembers(), (Object)consistentHashModified.getMembers());
    }

    @Test
    void notEqualsForModifiedInstanceWithDefaultInstance() throws Exception {
        ConsistentHash consistentHash = new ConsistentHash(s -> "fixed").with(this.member1, 1, (CommandMessageFilter)AcceptAll.INSTANCE);
        Assertions.assertNotEquals((Object)consistentHash, (Object)new ConsistentHash());
    }
}

