/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.util.Collections;
import java.util.Map;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.distributed.MetaDataRoutingStrategy;
import org.axonframework.commandhandling.distributed.RoutingStrategy;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MetaDataRoutingStrategyTest {
    private static final String META_DATA_KEY = "some-metadata-key";
    private MetaDataRoutingStrategy testSubject;
    private final RoutingStrategy fallbackRoutingStrategy = (RoutingStrategy)Mockito.mock(RoutingStrategy.class);

    MetaDataRoutingStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = MetaDataRoutingStrategy.builder().metaDataKey(META_DATA_KEY).fallbackRoutingStrategy(this.fallbackRoutingStrategy).build();
    }

    @Test
    void resolvesRoutingKeyFromMetaData() {
        String expectedRoutingKey = "some-routing-key";
        MetaData testMetaData = MetaData.from(Collections.singletonMap(META_DATA_KEY, expectedRoutingKey));
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)"some-payload", (Map)testMetaData);
        Assertions.assertEquals((Object)expectedRoutingKey, (Object)this.testSubject.getRoutingKey((CommandMessage)testCommand));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.fallbackRoutingStrategy});
    }

    @Test
    void resolvesRoutingKeyFromFallbackStrategy() {
        String expectedRoutingKey = "some-routing-key";
        Mockito.when((Object)this.fallbackRoutingStrategy.getRoutingKey((CommandMessage)Mockito.any())).thenReturn((Object)expectedRoutingKey);
        GenericCommandMessage testCommand = new GenericCommandMessage((Object)"some-payload", (Map)MetaData.emptyInstance());
        Assertions.assertEquals((Object)expectedRoutingKey, (Object)this.testSubject.getRoutingKey((CommandMessage)testCommand));
        ((RoutingStrategy)Mockito.verify((Object)this.fallbackRoutingStrategy)).getRoutingKey((CommandMessage)testCommand);
    }

    @Test
    void buildMetaDataRoutingStrategyFailsForNullFallbackRoutingStrategy() {
        MetaDataRoutingStrategy.Builder builderTestSubject = MetaDataRoutingStrategy.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.fallbackRoutingStrategy(null));
    }

    @Test
    void buildMetaDataRoutingStrategyFailsForNullMetaDataKey() {
        MetaDataRoutingStrategy.Builder builderTestSubject = MetaDataRoutingStrategy.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.metaDataKey(null));
    }

    @Test
    void buildMetaDataRoutingStrategyFailsForEmptyMetaDataKey() {
        MetaDataRoutingStrategy.Builder builderTestSubject = MetaDataRoutingStrategy.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.metaDataKey(""));
    }
}

