/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed;

import java.io.Serializable;
import java.util.Collection;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.distributed.ReplyMessage;
import org.axonframework.messaging.RemoteHandlingException;
import org.axonframework.messaging.RemoteNonTransientHandlingException;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ReplyMessageSerializationTest {
    ReplyMessageSerializationTest() {
    }

    public static Collection<TestSerializer> serializers() {
        return TestSerializer.all();
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void serializationDeserializationOfSuccessfulMessage(TestSerializer serializer) {
        String commandId = "commandId";
        CommandResultMessage success = GenericCommandResultMessage.asCommandResultMessage((Object)"success");
        DummyReplyMessage message = new DummyReplyMessage(commandId, success, serializer.getSerializer());
        Assertions.assertEquals((Object)message, (Object)serializer.serializeDeserialize(message));
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void serializationDeserializationOfUnsuccessfulMessage(TestSerializer serializer) {
        String commandId = "commandId";
        CommandResultMessage failure = GenericCommandResultMessage.asCommandResultMessage((Throwable)new RuntimeException("oops"));
        DummyReplyMessage message = new DummyReplyMessage(commandId, failure, serializer.getSerializer());
        Assertions.assertEquals((Object)message, (Object)serializer.serializeDeserialize(message));
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void deserializingOfPersistentExceptions(TestSerializer serializer) {
        String commandId = "commandId";
        CommandResultMessage failure = GenericCommandResultMessage.asCommandResultMessage((Throwable)new SerializationException("oops"));
        DummyReplyMessage message = new DummyReplyMessage(commandId, failure, serializer.getSerializer());
        CommandResultMessage commandResultMessage = message.getCommandResultMessage(serializer.getSerializer());
        Assertions.assertTrue((boolean)(commandResultMessage.exceptionResult() instanceof CommandExecutionException));
        Assertions.assertTrue((boolean)(commandResultMessage.exceptionResult().getCause() instanceof RemoteNonTransientHandlingException));
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void deserializingOfTransientExceptions(TestSerializer serializer) {
        String commandId = "commandId";
        CommandResultMessage failure = GenericCommandResultMessage.asCommandResultMessage((Throwable)new RuntimeException("oops"));
        DummyReplyMessage message = new DummyReplyMessage(commandId, failure, serializer.getSerializer());
        CommandResultMessage commandResultMessage = message.getCommandResultMessage(serializer.getSerializer());
        Assertions.assertTrue((boolean)(commandResultMessage.exceptionResult() instanceof CommandExecutionException));
        Assertions.assertTrue((boolean)(commandResultMessage.exceptionResult().getCause() instanceof RemoteHandlingException));
    }

    private static class DummyReplyMessage
    extends ReplyMessage
    implements Serializable {
        private static final long serialVersionUID = -6583822511843818492L;

        public DummyReplyMessage() {
        }

        public DummyReplyMessage(String commandIdentifier, CommandResultMessage<?> commandResultMessage, Serializer serializer) {
            super(commandIdentifier, commandResultMessage, serializer);
        }
    }
}

