/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.distributed.commandfilter;

import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.distributed.CommandMessageFilter;
import org.axonframework.commandhandling.distributed.commandfilter.AcceptAll;
import org.axonframework.commandhandling.distributed.commandfilter.CommandNameFilter;
import org.axonframework.commandhandling.distributed.commandfilter.DenyAll;
import org.axonframework.commandhandling.distributed.commandfilter.DenyCommandNameFilter;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CommandFilterTest {
    CommandFilterTest() {
    }

    @Test
    void acceptAll() {
        GenericCommandMessage testCommand = new GenericCommandMessage(new Object());
        Assertions.assertTrue((boolean)AcceptAll.INSTANCE.matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)AcceptAll.INSTANCE.negate().matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)AcceptAll.INSTANCE.or((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)AcceptAll.INSTANCE.and((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
    }

    @Test
    void denyAll() {
        GenericCommandMessage testCommand = new GenericCommandMessage(new Object());
        Assertions.assertFalse((boolean)DenyAll.INSTANCE.matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)DenyAll.INSTANCE.negate().matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)DenyAll.INSTANCE.or((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)DenyAll.INSTANCE.and((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
    }

    @Test
    void commandNameFilter() {
        GenericCommandMessage testCommand = new GenericCommandMessage((Message)new GenericMessage(new Object()), "acceptable");
        CommandNameFilter filterAcceptable = new CommandNameFilter("acceptable");
        CommandNameFilter filterOther = new CommandNameFilter("other");
        Assertions.assertTrue((boolean)filterAcceptable.matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.negate().matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.negate().matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.or((CommandMessageFilter)filterAcceptable).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.or((CommandMessageFilter)filterOther).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.and((CommandMessageFilter)filterAcceptable).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.and((CommandMessageFilter)filterOther).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.or((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.or((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.and((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.and((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.or((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.or((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.and((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.and((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
    }

    @Test
    void denyCommandNameFilter() {
        GenericCommandMessage testCommand = new GenericCommandMessage((Message)new GenericMessage(new Object()), "acceptable");
        DenyCommandNameFilter filterAcceptable = new DenyCommandNameFilter("acceptable");
        DenyCommandNameFilter filterOther = new DenyCommandNameFilter("other");
        Assertions.assertFalse((boolean)filterAcceptable.matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.negate().matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.negate().matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.or((CommandMessageFilter)filterAcceptable).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.or((CommandMessageFilter)filterOther).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.and((CommandMessageFilter)filterAcceptable).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.and((CommandMessageFilter)filterOther).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.or((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.or((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterOther.and((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterOther.and((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.or((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertTrue((boolean)filterAcceptable.or((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.and((CommandMessageFilter)DenyAll.INSTANCE).matches((CommandMessage)testCommand));
        Assertions.assertFalse((boolean)filterAcceptable.and((CommandMessageFilter)AcceptAll.INSTANCE).matches((CommandMessage)testCommand));
    }
}

