/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandExecutionException;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.commandhandling.GenericCommandResultMessage;
import org.axonframework.commandhandling.gateway.CommandGatewayFactory;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.commandhandling.gateway.RetryingCallback;
import org.axonframework.commandhandling.gateway.Timeout;
import org.axonframework.common.lock.DeadlockException;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.responsetypes.ResponseTypes;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class CommandGatewayFactoryTest {
    private CommandBus mockCommandBus;
    private RetryScheduler mockRetryScheduler;
    private CompleteGateway gateway;
    private CommandCallback callback;
    private CommandGatewayFactory testSubject;

    CommandGatewayFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockCommandBus = (CommandBus)Mockito.mock(CommandBus.class);
        this.mockRetryScheduler = (RetryScheduler)Mockito.mock(RetryScheduler.class);
        this.testSubject = CommandGatewayFactory.builder().commandBus(this.mockCommandBus).retryScheduler(this.mockRetryScheduler).build();
        this.callback = (CommandCallback)Mockito.spy((Object)new StringCommandCallback());
        this.testSubject.registerCommandCallback((commandMessage, commandResultMessage) -> {}, ResponseTypes.instanceOf(String.class));
        this.testSubject.registerCommandCallback(this.callback, ResponseTypes.instanceOf(String.class));
        this.gateway = (CompleteGateway)this.testSubject.createGateway(CompleteGateway.class);
    }

    @Test
    @Timeout(value=2)
    void gatewayFireAndForget() {
        Object metaTest = new Object();
        ((CommandBus)Mockito.doAnswer((Answer)new Success(GenericCommandResultMessage.asCommandResultMessage(null))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        this.testSubject.registerCommandCallback(this.callback, ResponseTypes.instanceOf(Void.class));
        this.gateway.fireAndForget("Command", null, metaTest, "value");
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.argThat(x -> x.getMetaData().get((Object)"test") == metaTest && "value".equals(x.getMetaData().get((Object)"key"))), (CommandCallback)Mockito.isA(RetryingCallback.class));
        ((CommandCallback)Mockito.verify((Object)this.callback)).onResult((CommandMessage)Mockito.isA(CommandMessage.class), (CommandResultMessage)Mockito.any());
    }

    @Test
    @Timeout(value=2)
    void gatewayFireAndForgetWithoutRetryScheduler() {
        Object metaTest = new Object();
        CommandGatewayFactory testSubject = CommandGatewayFactory.builder().commandBus(this.mockCommandBus).build();
        CompleteGateway gateway = (CompleteGateway)testSubject.createGateway(CompleteGateway.class);
        gateway.fireAndForget("Command", MetaData.from(Collections.singletonMap("otherKey", "otherVal")), metaTest, "value");
        ((CommandBus)Mockito.verify((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.argThat(x -> x.getMetaData().get((Object)"test") == metaTest && "otherVal".equals(x.getMetaData().get((Object)"otherKey")) && "value".equals(x.getMetaData().get((Object)"key"))));
    }

    @Test
    @Timeout(value=5)
    void gatewayTimeout() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((CommandBus)Mockito.doAnswer((Answer)new CountDown(latch)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWait("Command");
                Assertions.fail((String)"Expected a TimeoutException to be thrown");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Expected command bus to be invoked");
        Assertions.assertTrue((boolean)t.isAlive());
        t.join(500L);
    }

    @Test
    @Timeout(value=2)
    void gatewayWithReturnValueReturns() throws InterruptedException {
        String expectedReturnValue = "ReturnValue";
        CommandResultMessage returnValue = GenericCommandResultMessage.asCommandResultMessage((Object)expectedReturnValue);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Success(latch, returnValue)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> result.set(this.gateway.waitForReturnValue("Command")));
        t.start();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Expected command bus to be invoked");
        t.join();
        Assertions.assertEquals((Object)expectedReturnValue, result.get());
        ((CommandCallback)Mockito.verify((Object)this.callback)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)returnValue));
    }

    @Test
    @Timeout(value=2)
    void gatewayWithReturnValueUndeclaredException() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(latch, new ExpectedException())).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.waitForReturnValue("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS), (String)"Expected command bus to be invoked");
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof CommandExecutionException));
        Assertions.assertTrue((boolean)(((Throwable)error.get()).getCause() instanceof ExpectedException));
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)this.callback)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(ExpectedException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    @Test
    @Timeout(value=2)
    void gatewayWithReturnValueInterrupted() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.waitForReturnValue("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.interrupt();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof CommandExecutionException), (String)"Expected CommandExecutionException");
        Assertions.assertTrue((boolean)(((Throwable)error.get()).getCause() instanceof InterruptedException), (String)"Expected wrapped InterruptedException");
    }

    @Test
    void gatewayWithReturnValueRuntimeException() {
        AtomicReference<String> result = new AtomicReference<String>();
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        RuntimeException runtimeException = new RuntimeException();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(null, runtimeException)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        try {
            result.set(this.gateway.waitForReturnValue("Command"));
        }
        catch (Throwable e) {
            error.set(e);
        }
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertSame((Object)runtimeException, error.get(), (String)"Expected exact instance of RunTimeException being propagated");
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)this.callback)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertEquals(RuntimeException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    @Test
    @Timeout(value=2)
    void gatewayWaitForExceptionInterrupted() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                this.gateway.waitForException("Command");
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.interrupt();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof InterruptedException));
    }

    @Test
    @Timeout(value=2)
    void gatewayWaitForUndeclaredInterruptedException() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                this.gateway.waitForReturnValue("Command");
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.interrupt();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof CommandExecutionException));
    }

    @Test
    @Timeout(value=2)
    void fireAndWaitWithTimeoutParameterReturns() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Success(latch, GenericCommandResultMessage.asCommandResultMessage((Object)"OK!"))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWaitWithTimeoutParameter("Command", 1L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        t.interrupt();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertNull(error.get(), (String)"Did not expect exception");
    }

    @Test
    @Timeout(value=2)
    void fireAndWaitWithTimeoutParameterTimeout() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWaitWithTimeoutParameter("Command", 1L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof CommandExecutionException), (String)"Expected CommandExecutionException");
        Assertions.assertTrue((boolean)(((Throwable)error.get()).getCause() instanceof TimeoutException), (String)"Expected wrapped InterruptedException");
    }

    @Test
    @Timeout(value=2)
    void fireAndWaitWithTimeoutParameterTimeoutException() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWaitWithTimeoutParameterAndException("Command", 1L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof TimeoutException));
    }

    @Test
    @Timeout(value=2)
    void fireAndWaitWithTimeoutParameterInterrupted() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWaitWithTimeoutParameter("Command", 1L, TimeUnit.SECONDS);
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.interrupt();
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof CommandExecutionException), (String)"Expected CommandExecutionException");
        Assertions.assertTrue((boolean)(((Throwable)error.get()).getCause() instanceof InterruptedException), (String)"Expected wrapped InterruptedException");
    }

    @Test
    @Timeout(value=2)
    void fireAndWaitForCheckedException() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(latch, new ExpectedException())).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                this.gateway.fireAndWaitForCheckedException("Command");
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        t.join();
        Assertions.assertNull(result.get(), (String)"Did not expect ReturnValue");
        Assertions.assertTrue((boolean)(error.get() instanceof ExpectedException));
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)this.callback)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertTrue((boolean)((CommandResultMessage)commandResultMessageCaptor.getValue()).isExceptional());
        Assertions.assertEquals(ExpectedException.class, ((CommandResultMessage)commandResultMessageCaptor.getValue()).exceptionResult().getClass());
    }

    @Test
    @Timeout(value=2)
    void fireAndGetFuture() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.fireAndGetFuture("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNotNull(result.get(), (String)"Expected to get a Future return value");
        Assertions.assertNull(error.get());
    }

    @Test
    @Timeout(value=2)
    void fireAndGetCompletableFuture() throws InterruptedException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.fireAndGetCompletableFuture("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNotNull(result.get(), (String)"Expected to get a Future return value");
        Assertions.assertNull(error.get());
    }

    @Test
    @Timeout(value=2)
    void fireAndGetFutureWithTimeout() throws Throwable {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.futureWithTimeout("Command", 100, TimeUnit.SECONDS));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNotNull(result.get(), (String)"Expected to get a Future return value");
        Assertions.assertNull(error.get());
    }

    @Test
    @Timeout(value=2)
    void fireAndGetCompletionStageWithTimeout() throws Throwable {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.fireAndGetCompletionStage("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        Assertions.assertNotNull(result.get(), (String)"Expected to get a CompletionStage return value");
        Assertions.assertNull(error.get());
    }

    @Test
    @Timeout(value=2)
    void retrySchedulerInvokedOnFailure() throws Throwable {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(new SomeRuntimeException())).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.waitForReturnValue("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler)).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.isA(SomeRuntimeException.class), Mockito.anyList(), (Runnable)Mockito.any(Runnable.class));
        Assertions.assertNotNull(error.get());
        Assertions.assertNull(result.get(), (String)"Did not Expect to get a Future return value");
    }

    @Test
    @Timeout(value=2)
    void retrySchedulerNotInvokedOnCheckedException() throws Throwable {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(new ExpectedException())).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Thread t = new Thread(() -> {
            try {
                result.set(this.gateway.waitForReturnValue("Command"));
            }
            catch (Throwable e) {
                error.set(e);
            }
        });
        t.start();
        t.join();
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.never())).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.any(RuntimeException.class), Mockito.anyList(), (Runnable)Mockito.any(Runnable.class));
        Assertions.assertNotNull(error.get());
        Assertions.assertNull(result.get(), (String)"Did not Expect to get a Future return value");
    }

    @Test
    @Timeout(value=2)
    void retrySchedulerInvokedOnExceptionCausedByDeadlock() {
        AtomicReference<String> result = new AtomicReference<String>();
        AtomicReference<Exception> error = new AtomicReference<Exception>();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(new RuntimeException(new DeadlockException("Mock")))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        try {
            result.set(this.gateway.waitForReturnValue("Command"));
        }
        catch (Exception e) {
            error.set(e);
        }
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler)).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.any(RuntimeException.class), Mockito.anyList(), (Runnable)Mockito.any(Runnable.class));
        Assertions.assertNotNull(error.get());
        Assertions.assertNull(result.get(), (String)"Did not Expect to get a Future return value");
    }

    @Test
    @Timeout(value=2)
    void createGatewayWaitForResultAndInvokeCallbacksSuccess() {
        CountDownLatch latch = new CountDownLatch(1);
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)"OK");
        CommandCallback callback1 = (CommandCallback)Mockito.mock(CommandCallback.class);
        CommandCallback callback2 = (CommandCallback)Mockito.mock(CommandCallback.class);
        ((CommandBus)Mockito.doAnswer((Answer)new Success(latch, resultMessage)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Object result = this.gateway.fireAndWaitAndInvokeCallbacks("Command", callback1, callback2);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        Assertions.assertNotNull((Object)result);
        ((CommandCallback)Mockito.verify((Object)callback1)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
        ((CommandCallback)Mockito.verify((Object)callback2)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
    }

    @Test
    @Timeout(value=2)
    void createGatewayWaitForResultAndInvokeCallbacksFailure() {
        RuntimeException exception = new RuntimeException();
        CommandCallback callback1 = (CommandCallback)Mockito.mock(CommandCallback.class);
        CommandCallback callback2 = (CommandCallback)Mockito.mock(CommandCallback.class);
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(exception)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        try {
            this.gateway.fireAndWaitAndInvokeCallbacks("Command", callback1, callback2);
            Assertions.fail((String)"Expected exception");
        }
        catch (RuntimeException e) {
            ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
            ((CommandCallback)Mockito.verify((Object)callback1)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
            ((CommandCallback)Mockito.verify((Object)callback2)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
            Assertions.assertEquals((int)2, (int)commandResultMessageCaptor.getAllValues().size());
            Assertions.assertEquals((Object)exception, (Object)((CommandResultMessage)commandResultMessageCaptor.getAllValues().get(0)).exceptionResult());
            Assertions.assertEquals((Object)exception, (Object)((CommandResultMessage)commandResultMessageCaptor.getAllValues().get(1)).exceptionResult());
        }
    }

    @Test
    @Timeout(value=2)
    void createGatewayAsyncWithCallbacksSuccess() {
        CountDownLatch latch = new CountDownLatch(1);
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)"OK");
        CommandCallback callback1 = (CommandCallback)Mockito.mock(CommandCallback.class);
        CommandCallback callback2 = (CommandCallback)Mockito.mock(CommandCallback.class);
        ((CommandBus)Mockito.doAnswer((Answer)new Success(latch, resultMessage)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        this.gateway.fireAsyncWithCallbacks("Command", callback1, callback2);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        ((CommandCallback)Mockito.verify((Object)callback1)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
        ((CommandCallback)Mockito.verify((Object)callback2)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
    }

    @Test
    @Timeout(value=2)
    void createGatewayAsyncWithCallbacksSuccessButReturnTypeDoesNotMatchCallback() {
        CountDownLatch latch = new CountDownLatch(1);
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)42);
        CommandCallback callback1 = (CommandCallback)Mockito.mock(CommandCallback.class);
        CommandCallback callback2 = (CommandCallback)Mockito.mock(CommandCallback.class);
        ((CommandBus)Mockito.doAnswer((Answer)new Success(latch, resultMessage)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        this.gateway.fireAsyncWithCallbacks("Command", callback1, callback2);
        Assertions.assertEquals((long)0L, (long)latch.getCount());
        ((CommandCallback)Mockito.verify((Object)callback1)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
        ((CommandCallback)Mockito.verify((Object)callback2)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.eq((Object)resultMessage));
        ((CommandCallback)Mockito.verify((Object)this.callback, (VerificationMode)Mockito.never())).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)Mockito.any());
    }

    @Test
    @Timeout(value=2)
    void createGatewayAsyncWithCallbacksFailure() {
        RuntimeException exception = new RuntimeException();
        CommandCallback callback1 = (CommandCallback)Mockito.mock(CommandCallback.class);
        CommandCallback callback2 = (CommandCallback)Mockito.mock(CommandCallback.class);
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(exception)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        this.gateway.fireAsyncWithCallbacks("Command", callback1, callback2);
        ArgumentCaptor commandResultMessageCaptor = ArgumentCaptor.forClass(CommandResultMessage.class);
        ((CommandCallback)Mockito.verify((Object)callback1)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        ((CommandCallback)Mockito.verify((Object)callback2)).onResult((CommandMessage)Mockito.any(), (CommandResultMessage)commandResultMessageCaptor.capture());
        Assertions.assertEquals((int)2, (int)commandResultMessageCaptor.getAllValues().size());
        Assertions.assertEquals((Object)exception, (Object)((CommandResultMessage)commandResultMessageCaptor.getAllValues().get(0)).exceptionResult());
        Assertions.assertEquals((Object)exception, (Object)((CommandResultMessage)commandResultMessageCaptor.getAllValues().get(1)).exceptionResult());
    }

    @Test
    @Timeout(value=2)
    void createGatewayCompletableFutureFailure() {
        RuntimeException exception = new RuntimeException();
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(exception)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        CompletableFuture<Object> future = this.gateway.fireAndGetCompletableFuture("Command");
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
    }

    @Test
    @Timeout(value=2)
    void createGatewayCompletableFutureSuccessfulResult() throws Throwable {
        String expectedReturnValue = "returnValue";
        ((CommandBus)Mockito.doAnswer((Answer)new Success(GenericCommandResultMessage.asCommandResultMessage((Object)expectedReturnValue))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        CompletableFuture<Object> future = this.gateway.fireAndGetCompletableFuture("Command");
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)expectedReturnValue, (Object)future.get());
    }

    @Test
    @Timeout(value=2)
    void createGatewayFutureSuccessfulResult() throws Throwable {
        String expectedReturnValue = "returnValue";
        ((CommandBus)Mockito.doAnswer((Answer)new Success(GenericCommandResultMessage.asCommandResultMessage((Object)expectedReturnValue))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Future<Object> future = this.gateway.fireAndGetFuture("Command");
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((Object)"returnValue", (Object)future.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=2)
    void retrySchedulerNotInvokedOnExceptionCausedByDeadlockAndActiveUnitOfWork() {
        AtomicReference<String> result = new AtomicReference<String>();
        AtomicReference<Exception> error = new AtomicReference<Exception>();
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        ((CommandBus)Mockito.doAnswer((Answer)new Failure(new RuntimeException(new DeadlockException("Mock")))).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        try {
            result.set(this.gateway.waitForReturnValue("Command"));
        }
        catch (Exception e) {
            error.set(e);
        }
        finally {
            uow.rollback();
        }
        ((RetryScheduler)Mockito.verify((Object)this.mockRetryScheduler, (VerificationMode)Mockito.never())).scheduleRetry((CommandMessage)Mockito.isA(CommandMessage.class), (RuntimeException)Mockito.any(RuntimeException.class), Mockito.anyList(), (Runnable)Mockito.any(Runnable.class));
        Assertions.assertNotNull(error.get());
        Assertions.assertNull(result.get(), (String)"Did not Expect to get a Future return value");
    }

    @Test
    @Timeout(value=2)
    void createGatewayEqualsAndHashCode() {
        CompleteGateway gateway2 = (CompleteGateway)this.testSubject.createGateway(CompleteGateway.class);
        Assertions.assertNotSame((Object)this.gateway, (Object)gateway2);
        Assertions.assertNotEquals((Object)this.gateway, (Object)gateway2);
    }

    @Test
    void differentCommandCallbackResultTypesInvocationsAreAllInvoked() {
        String expectedResult = "OK";
        AtomicBoolean stringCallbackInvocation = new AtomicBoolean(false);
        AtomicBoolean integerCallbackInvocation = new AtomicBoolean(false);
        CommandResultMessage resultMessage = GenericCommandResultMessage.asCommandResultMessage((Object)expectedResult);
        CommandCallback stringCallback = (command, result) -> stringCallbackInvocation.set(true);
        CommandCallback integerCallback = (command, result) -> integerCallbackInvocation.set(true);
        ((CommandBus)Mockito.doAnswer((Answer)new Success(resultMessage)).when((Object)this.mockCommandBus)).dispatch((CommandMessage)Mockito.isA(CommandMessage.class), (CommandCallback)Mockito.isA(CommandCallback.class));
        Object result2 = this.gateway.fireAsyncWithCallbacksOfSpecificResultType("Command", (CommandCallback<Object, String>)stringCallback, (CommandCallback<Object, Integer>)integerCallback);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertEquals((Object)expectedResult, (Object)result2);
        Assertions.assertTrue((boolean)stringCallbackInvocation.get());
        Assertions.assertTrue((boolean)integerCallbackInvocation.get());
    }

    private static class CountDown
    implements Answer<Object> {
        private final CountDownLatch cdl;

        CountDown(CountDownLatch cdl) {
            this.cdl = cdl;
        }

        public Object answer(InvocationOnMock invocation) {
            this.cdl.countDown();
            return null;
        }
    }

    private static class Failure
    implements Answer<Object> {
        private final CountDownLatch latch;
        private final Exception e;

        Failure(CountDownLatch latch, Exception e) {
            this.latch = latch;
            this.e = e;
        }

        Failure(Exception e) {
            this(null, e);
        }

        public Object answer(InvocationOnMock invocation) {
            if (this.latch != null) {
                this.latch.countDown();
            }
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], GenericCommandResultMessage.asCommandResultMessage((Throwable)this.e));
            return null;
        }
    }

    private static class Success
    implements Answer<Object> {
        private final CountDownLatch latch;
        private final CommandResultMessage<?> returnValue;

        Success(CommandResultMessage<?> returnValue) {
            this(new CountDownLatch(1), returnValue);
        }

        Success(CountDownLatch latch, CommandResultMessage<?> returnValue) {
            this.latch = latch;
            this.returnValue = returnValue;
        }

        public Object answer(InvocationOnMock invocation) {
            this.latch.countDown();
            ((CommandCallback)invocation.getArguments()[1]).onResult((CommandMessage)invocation.getArguments()[0], this.returnValue);
            return null;
        }
    }

    private static class ExpectedException
    extends Exception {
        private ExpectedException() {
        }
    }

    private static class SomeRuntimeException
    extends RuntimeException {
        private SomeRuntimeException() {
        }
    }

    private static class StringCommandCallback
    implements CommandCallback<Object, String> {
        private StringCommandCallback() {
        }

        public void onResult(@Nonnull CommandMessage<?> commandMessage, @Nonnull CommandResultMessage<? extends String> commandResultMessage) {
        }
    }

    private static interface CompleteGateway {
        public void fireAndForget(Object var1, MetaData var2, @MetaDataValue(value="test") Object var3, @MetaDataValue(value="key") Object var4);

        public String waitForReturnValue(Object var1);

        public void waitForException(Object var1) throws InterruptedException;

        @Timeout(value=1, unit=TimeUnit.SECONDS)
        public void fireAndWait(Object var1) throws TimeoutException;

        public void fireAndWaitWithTimeoutParameter(Object var1, long var2, TimeUnit var4);

        public Object fireAndWaitWithTimeoutParameterAndException(Object var1, long var2, TimeUnit var4) throws TimeoutException;

        public Object fireAndWaitForCheckedException(Object var1) throws ExpectedException;

        public Future<Object> fireAndGetFuture(Object var1);

        public CompletableFuture<Object> fireAndGetCompletableFuture(Object var1);

        public CompletionStage<Object> fireAndGetCompletionStage(Object var1);

        public CompletableFuture<Object> futureWithTimeout(Object var1, int var2, TimeUnit var3);

        public Object fireAndWaitAndInvokeCallbacks(Object var1, CommandCallback<Object, ?> var2, CommandCallback<Object, ?> var3);

        public void fireAsyncWithCallbacks(Object var1, CommandCallback<Object, ?> var2, CommandCallback<Object, ?> var3);

        public Object fireAsyncWithCallbacksOfSpecificResultType(Object var1, CommandCallback<Object, String> var2, CommandCallback<Object, Integer> var3);
    }
}

