/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.gateway.IntervalRetryScheduler;
import org.axonframework.commandhandling.gateway.RetryScheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.jdbc.JdbcException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IntervalRetrySchedulerTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int RETRY_INTERVAL = 100;
    private static final int MAX_RETRIES = 5;
    private IntervalRetryScheduler retryScheduler;

    IntervalRetrySchedulerTest() {
    }

    @BeforeEach
    void setup() {
        this.retryScheduler = ((IntervalRetryScheduler.Builder)((IntervalRetryScheduler.Builder)IntervalRetryScheduler.builder().retryExecutor((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1))).retryInterval(100).maxRetryCount(5)).build();
    }

    static long doScheduleRetry(RetryScheduler retryScheduler, int nrOfFailures) {
        CommandMessage msg = GenericCommandMessage.asCommandMessage((Object)"Hello world");
        Instant before = Instant.now();
        FutureTask<Instant> after = new FutureTask<Instant>(Instant::now);
        JdbcException exc = new JdbcException("Exception", (Throwable)new NullPointerException());
        ArrayList<Class[]> failures = new ArrayList<Class[]>();
        for (int i = 0; i < nrOfFailures; ++i) {
            Class[] arr = new Class[]{JdbcException.class, NullPointerException.class};
            failures.add(arr);
        }
        if (retryScheduler.scheduleRetry(msg, (RuntimeException)exc, failures, after)) {
            try {
                Instant afterInstant = after.get();
                logger.info("scheduleRetry(): Actual delay was {}ms. (nr of failures {} out of max {})", new Object[]{afterInstant.toEpochMilli() - before.toEpochMilli(), nrOfFailures, 5});
                return afterInstant.toEpochMilli() - before.toEpochMilli();
            }
            catch (InterruptedException ex) {
                Assertions.fail((String)"Test failed: somebody interrupted us.");
            }
            catch (ExecutionException ex) {
                Assertions.fail((String)"Test failed: An exception occurred where none should be.");
            }
        }
        return 0L;
    }

    @Test
    void scheduleRetry() {
        for (int nrOfFailures = 1; nrOfFailures <= 5; ++nrOfFailures) {
            Assertions.assertTrue((IntervalRetrySchedulerTest.doScheduleRetry((RetryScheduler)this.retryScheduler, nrOfFailures) >= 100L ? 1 : 0) != 0, (String)"Scheduling a retry should wait the required delay.");
        }
        Assertions.assertEquals((long)0L, (long)IntervalRetrySchedulerTest.doScheduleRetry((RetryScheduler)this.retryScheduler, 6), (String)"Scheduling a retry when past maxRetryCount should have failed.");
    }

    @Test
    void buildingWhilstMissingScheduledExecutorServiceThrowsConfigurationException() {
        IntervalRetryScheduler.Builder builder = IntervalRetryScheduler.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((IntervalRetryScheduler.Builder)builder).build());
    }
}

