/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import org.axonframework.common.AxonThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AxonThreadFactoryTest {
    private AxonThreadFactory testSubject;

    AxonThreadFactoryTest() {
    }

    @Test
    void createWithThreadGroupByName() {
        this.testSubject = new AxonThreadFactory("test");
        Thread t1 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Thread t2 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Assertions.assertEquals((Object)"test", (Object)t1.getThreadGroup().getName());
        Assertions.assertEquals((Object)"test-0", (Object)t1.getName());
        Assertions.assertEquals((Object)"test-1", (Object)t2.getName());
        Assertions.assertSame((Object)t1.getThreadGroup(), (Object)t2.getThreadGroup(), (String)"Expected only a single ThreadGroup");
    }

    @Test
    void createWithThreadGroupByThreadGroupInstance() {
        ThreadGroup threadGroup = new ThreadGroup("test");
        this.testSubject = new AxonThreadFactory(threadGroup);
        Thread t1 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Thread t2 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Assertions.assertEquals((Object)"test", (Object)t1.getThreadGroup().getName());
        Assertions.assertEquals((Object)"test-0", (Object)t1.getName());
        Assertions.assertSame((Object)threadGroup, (Object)t1.getThreadGroup(), (String)"Expected only a single ThreadGroup");
        Assertions.assertSame((Object)threadGroup, (Object)t2.getThreadGroup(), (String)"Expected only a single ThreadGroup");
    }

    @Test
    void createWithPriority() {
        ThreadGroup threadGroup = new ThreadGroup("test");
        this.testSubject = new AxonThreadFactory(10, threadGroup);
        Thread t1 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Thread t2 = this.testSubject.newThread((Runnable)new NoOpRunnable());
        Assertions.assertEquals((Object)"test", (Object)t1.getThreadGroup().getName());
        Assertions.assertEquals((int)10, (int)t1.getPriority());
        Assertions.assertSame((Object)threadGroup, (Object)t1.getThreadGroup(), (String)"Expected only a single ThreadGroup");
        Assertions.assertSame((Object)threadGroup, (Object)t2.getThreadGroup(), (String)"Expected only a single ThreadGroup");
    }

    @Test
    void rejectsTooHighPriority() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AxonThreadFactory(11, new ThreadGroup("")));
    }

    @Test
    void rejectsTooLowPriority() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new AxonThreadFactory(0, new ThreadGroup("")));
    }

    private static class NoOpRunnable
    implements Runnable {
        private NoOpRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

